/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.block;

import java.util.Locale;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFEnum;
import joshie.harvest.core.util.Text;
import joshie.harvest.mining.MiningHelper;
import joshie.harvest.npc.entity.EntityNPC;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPortal
extends BlockHFEnum<BlockPortal, Portal> {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockPortal() {
        super(Material.field_151576_e, Portal.class, HFTab.MINING);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177230_c() == this ? ((Portal)((Object)this.getEnumFromState(state))).ordinal() % 6 : 0;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return -1.0f;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return 6.0E7f;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        return Text.localizeFully(this.func_149739_a());
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return AABB;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        IBlockState actual;
        if (!world.field_72995_K && entity.field_71088_bW == 0 && !(entity instanceof EntityNPC) && (actual = this.func_176221_a(state, (IBlockAccess)world, pos)).func_177230_c() == this) {
            Portal portal = (Portal)((Object)this.getEnumFromState(actual));
            if (portal.isInternal()) {
                MiningHelper.teleportBetweenMine(entity);
            } else if (portal.isMine()) {
                MiningHelper.teleportToOverworld(entity);
            } else {
                MiningHelper.teleportToMine(entity);
            }
        }
    }

    private boolean isSameBlock(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this;
    }

    private int getDimension(IBlockAccess access) {
        if (access instanceof World) {
            return ((World)access).field_73011_w.getDimension();
        }
        if (access instanceof ChunkCache) {
            return ((ChunkCache)access).field_72815_e.field_73011_w.getDimension();
        }
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Type type = this.getDimension(world) == 0 ? Type.OVERWORLD : Type.MINE;
        boolean internal = type == Type.MINE && MiningHelper.getFloor(pos.func_177958_n() >> 4, pos.func_177956_o()) != 1;
        boolean connectedUp = this.isSameBlock(world, pos.func_177984_a());
        boolean connectedDown = this.isSameBlock(world, pos.func_177977_b());
        boolean connectedEast = this.isSameBlock(world, pos.func_177974_f());
        boolean connectedWest = this.isSameBlock(world, pos.func_177976_e());
        boolean connectedSouth = this.isSameBlock(world, pos.func_177968_d());
        boolean connectedNorth = this.isSameBlock(world, pos.func_177978_c());
        if (connectedDown && (!connectedEast && connectedWest || connectedNorth && !connectedSouth)) {
            if (connectedWest) {
                return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_TL_EW) : this.getStateFromEnum(Portal.MINE_TL_EW)) : this.getStateFromEnum(Portal.STONE_TL_EW);
            }
            return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_TL) : this.getStateFromEnum(Portal.MINE_TL)) : this.getStateFromEnum(Portal.STONE_TL);
        }
        if (connectedDown && (connectedEast && !connectedWest || !connectedNorth && connectedSouth)) {
            if (connectedEast) {
                return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_TR_EW) : this.getStateFromEnum(Portal.MINE_TR_EW)) : this.getStateFromEnum(Portal.STONE_TR_EW);
            }
            return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_TR) : this.getStateFromEnum(Portal.MINE_TR)) : this.getStateFromEnum(Portal.STONE_TR);
        }
        if (connectedDown && (connectedEast && connectedWest || connectedNorth && connectedSouth)) {
            if (connectedWest) {
                return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_TM_EW) : this.getStateFromEnum(Portal.MINE_TM_EW)) : this.getStateFromEnum(Portal.STONE_TM_EW);
            }
            return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_TM) : this.getStateFromEnum(Portal.MINE_TM)) : this.getStateFromEnum(Portal.STONE_TM);
        }
        if (connectedUp && (!connectedEast && connectedWest || connectedNorth && !connectedSouth)) {
            if (connectedWest) {
                return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_BL_EW) : this.getStateFromEnum(Portal.MINE_BL_EW)) : this.getStateFromEnum(Portal.STONE_BL_EW);
            }
            return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_BL) : this.getStateFromEnum(Portal.MINE_BL)) : this.getStateFromEnum(Portal.STONE_BL);
        }
        if (connectedUp && (connectedEast && !connectedWest || !connectedNorth && connectedSouth)) {
            if (connectedEast) {
                return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_BR_EW) : this.getStateFromEnum(Portal.MINE_BR_EW)) : this.getStateFromEnum(Portal.STONE_BR_EW);
            }
            return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_BR) : this.getStateFromEnum(Portal.MINE_BR)) : this.getStateFromEnum(Portal.STONE_BR);
        }
        if (connectedUp && (connectedEast && connectedWest || connectedNorth && connectedSouth)) {
            if (connectedEast) {
                return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_BM_EW) : this.getStateFromEnum(Portal.MINE_BM_EW)) : this.getStateFromEnum(Portal.STONE_BM_EW);
            }
            return type == Type.MINE ? (internal ? this.getStateFromEnum(Portal.INTERNAL_BM) : this.getStateFromEnum(Portal.MINE_BM)) : this.getStateFromEnum(Portal.STONE_BM);
        }
        return state;
    }

    @Override
    protected boolean shouldDisplayInCreative(Portal e) {
        return false;
    }

    protected static enum Type {
        MINE,
        INTERNAL,
        OVERWORLD;

    }

    public static enum Portal implements IStringSerializable
    {
        MINE_TL,
        MINE_TM,
        MINE_TR,
        MINE_BL,
        MINE_BM,
        MINE_BR,
        MINE_TL_EW,
        MINE_TM_EW,
        MINE_TR_EW,
        MINE_BL_EW,
        MINE_BM_EW,
        MINE_BR_EW,
        INTERNAL_TL,
        INTERNAL_TM,
        INTERNAL_TR,
        INTERNAL_BL,
        INTERNAL_BM,
        INTERNAL_BR,
        INTERNAL_TL_EW,
        INTERNAL_TM_EW,
        INTERNAL_TR_EW,
        INTERNAL_BL_EW,
        INTERNAL_BM_EW,
        INTERNAL_BR_EW,
        STONE_TL,
        STONE_TM,
        STONE_TR,
        STONE_BL,
        STONE_BM,
        STONE_BR,
        STONE_TL_EW,
        STONE_TM_EW,
        STONE_TR_EW,
        STONE_BL_EW,
        STONE_BM_EW,
        STONE_BR_EW;


        public boolean isCentre() {
            return this == MINE_BM || this == MINE_BM_EW || this == INTERNAL_BM || this == INTERNAL_BM_EW;
        }

        public boolean isMine() {
            return this.ordinal() <= MINE_BR_EW.ordinal();
        }

        public boolean isInternal() {
            return this.ordinal() >= INTERNAL_TL.ordinal() && this.ordinal() <= INTERNAL_BR_EW.ordinal();
        }

        public boolean isStone() {
            return this.ordinal() >= STONE_TL.ordinal();
        }

        public boolean isEW() {
            return this.ordinal() % 12 >= 6;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

