/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.block;

import java.util.Locale;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.gathering.ISmashable;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFSmashable;
import joshie.harvest.core.base.item.ItemToolSmashing;
import joshie.harvest.core.lib.LootStrings;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.MiningHelper;
import joshie.harvest.mining.item.ItemMaterial;
import joshie.harvest.tools.HFTools;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockOre
extends BlockHFSmashable<BlockOre, Ore>
implements ISmashable {
    private static final AxisAlignedBB COPPER_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);

    public BlockOre() {
        super(Material.field_151576_e, Ore.class, HFTab.MINING);
        this.setBlockUnbreakable();
        this.func_149672_a(SoundType.field_185851_d);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        return player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == HFTools.HAMMER ? (float)(HFTools.HAMMER.getTier(player.func_184614_ca()).ordinal() + 1) * 0.05f - (float)this.getToolLevel((Ore)((Object)this.getEnumFromState(state))) * 0.025f : -1.0f;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return COPPER_AABB;
    }

    @Override
    public ISmashable.ToolType getToolType() {
        return ISmashable.ToolType.HAMMER;
    }

    @Override
    public ItemToolSmashing getTool() {
        return HFTools.HAMMER;
    }

    @Override
    protected int getToolLevel(Ore ore) {
        switch (ore) {
            case ROCK: 
            case COPPER: {
                return 1;
            }
            case SILVER: {
                return 2;
            }
            case GOLD: {
                return 3;
            }
            case MYSTRIL: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        EntityPlayer player;
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots && (player = (EntityPlayer)this.harvesters.get()) != null && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == this.getTool()) {
            this.smashBlock((EntityPlayer)this.harvesters.get(), worldIn, pos, state, this.getTool().getTier(player.func_184614_ca()));
        }
    }

    @Override
    public ItemStack getDrop(EntityPlayer player, World world, BlockPos pos, IBlockState state, float luck) {
        Ore ore = (Ore)((Object)this.getEnumFromState(state));
        if (world instanceof WorldServer) {
            WorldServer server = (WorldServer)world;
            server.func_175739_a(EnumParticleTypes.BLOCK_CRACK, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10, 0.5, 0.5, 0.5, 0.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P())});
        }
        switch (ore) {
            case ROCK: {
                ResourceLocation loot = HFApi.calendar.getDate(world).getSeason() == Season.WINTER ? LootStrings.MINE_WINTER : LootStrings.MINE_SPRING;
                return world.field_72995_K ? new ItemStack((Block)this) : MiningHelper.getLoot(loot, world, player, luck);
            }
            case COPPER: {
                return HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.COPPER, 1 + world.field_73012_v.nextInt(5));
            }
            case SILVER: {
                return HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.SILVER, 1 + world.field_73012_v.nextInt(3));
            }
            case GOLD: {
                return HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.GOLD, 1 + world.field_73012_v.nextInt(2));
            }
            case MYSTRIL: {
                return HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.MYSTRIL);
            }
        }
        return null;
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return -19 + stack.func_77952_i();
    }

    public static enum Ore implements IStringSerializable
    {
        ROCK,
        COPPER,
        SILVER,
        GOLD,
        MYSTRIL;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

