/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.block;

import java.util.Locale;
import javax.annotation.Nonnull;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFEnumRotatableTile;
import joshie.harvest.core.helpers.ChatHelper;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.MiningHelper;
import joshie.harvest.mining.TeleportPlayer;
import joshie.harvest.mining.item.ItemMiningTool;
import joshie.harvest.mining.tile.TileElevator;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockElevator
extends BlockHFEnumRotatableTile<BlockElevator, Elevator> {
    public BlockElevator() {
        super(Material.field_151575_d, Elevator.class, HFTab.MINING);
    }

    private TileElevator getElevator(World world, BlockPos pos, IBlockState state) {
        Elevator elevator = (Elevator)((Object)this.getEnumFromState(state));
        if (elevator == Elevator.EMPTY) {
            TileEntity tile = world.func_175625_s(pos.func_177977_b());
            if (tile instanceof TileElevator) {
                return (TileElevator)tile;
            }
        } else {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileElevator) {
                return (TileElevator)tile;
            }
        }
        return null;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileElevator elevator;
        if (entity instanceof EntityPlayer && (elevator = this.getElevator(world, pos, state)) != null) {
            BlockPos twin = elevator.getTwin();
            if (twin == null) {
                ChatHelper.displayChat("This elevator is not currently linked to another one");
            } else {
                EntityPlayer player = (EntityPlayer)entity;
                if (!TeleportPlayer.isTeleporting(player)) {
                    TileEntity target = world.func_175625_s(twin);
                    if (target instanceof TileElevator) {
                        EnumFacing facing = ((TileElevator)target).getFacing();
                        BlockPos location = twin.func_177972_a(facing);
                        TeleportPlayer.initiate(player, pos, facing, location);
                    }
                } else {
                    TeleportPlayer.onCollide(player);
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileElevator elevator = this.getElevator(world, pos, state);
        if (elevator != null) {
            if (heldItem != null && heldItem.func_77973_b() == HFMining.MINING_TOOL) {
                return false;
            }
            BlockPos twin = elevator.getTwin();
            if (twin == null) {
                ChatHelper.displayChat("This elevator is not currently linked to another one");
            } else {
                ChatHelper.displayChat("This elevator will take you to floor " + MiningHelper.getFloor((BlockPos)twin));
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileElevator elevator = this.getElevator(world, pos, state);
        if (elevator != null) {
            elevator.onBreakBlock();
        }
        super.func_180663_b(world, pos, state);
    }

    public IBlockState getStateFromPlacer(ItemMiningTool.MiningTool tool) {
        return this.getStateFromEnum(Elevator.JUNK);
    }

    @Override
    protected boolean shouldDisplayInCreative(Elevator ladder) {
        return false;
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileElevator();
    }

    public static enum Elevator implements IStringSerializable
    {
        EMPTY,
        JUNK;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

