/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining.block;

import java.util.List;
import java.util.Locale;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFBase;
import joshie.harvest.core.util.Text;
import joshie.harvest.mining.HFMining;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDirt
extends BlockHFBase<BlockDirt> {
    public static final PropertyEnum<TextureStyle> NORTH_EAST = PropertyEnum.func_177709_a((String)"ne", TextureStyle.class);
    public static final PropertyEnum<TextureStyle> NORTH_WEST = PropertyEnum.func_177709_a((String)"nw", TextureStyle.class);
    public static final PropertyEnum<TextureStyle> SOUTH_EAST = PropertyEnum.func_177709_a((String)"se", TextureStyle.class);
    public static final PropertyEnum<TextureStyle> SOUTH_WEST = PropertyEnum.func_177709_a((String)"sw", TextureStyle.class);

    public BlockDirt() {
        super(Material.field_151578_c, HFTab.MINING);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.func_176223_P().func_177226_a(NORTH_EAST, (Comparable)((Object)TextureStyle.OUTER)).func_177226_a(NORTH_WEST, (Comparable)((Object)TextureStyle.OUTER)).func_177226_a(SOUTH_EAST, (Comparable)((Object)TextureStyle.OUTER)).func_177226_a(SOUTH_WEST, (Comparable)((Object)TextureStyle.OUTER)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH_EAST, NORTH_WEST, SOUTH_EAST, SOUTH_WEST});
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        return Text.localizeFully(this.func_149739_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        if (stack.func_77973_b() == Item.func_150898_a((Block)HFMining.DIRT_DECORATIVE)) {
            list.add(TextFormatting.YELLOW + Text.translate("tooltip.cosmetic"));
        }
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.field_149782_v != -1.0f;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return plantable.getPlantType(world, pos.func_177984_a()) == EnumPlantType.Plains;
    }

    private boolean isSameBlock(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this;
    }

    private TextureStyle getStateFromBoolean(boolean one, boolean two, boolean three) {
        if (one && !two && !three) {
            return TextureStyle.VERTICAL;
        }
        if (!one && two && !three) {
            return TextureStyle.HORIZONTAL;
        }
        if (one && two && !three) {
            return TextureStyle.INNER;
        }
        if (!one && two) {
            return TextureStyle.HORIZONTAL;
        }
        if (one && !two) {
            return TextureStyle.VERTICAL;
        }
        if (one) {
            return TextureStyle.BLANK;
        }
        return TextureStyle.OUTER;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean north = this.isSameBlock(world, pos.func_177978_c());
        boolean west = this.isSameBlock(world, pos.func_177976_e());
        boolean south = this.isSameBlock(world, pos.func_177968_d());
        boolean east = this.isSameBlock(world, pos.func_177974_f());
        boolean northEast = north && east && this.isSameBlock(world, pos.func_177978_c().func_177974_f());
        boolean northWest = north && west && this.isSameBlock(world, pos.func_177978_c().func_177976_e());
        boolean southEast = south && east && this.isSameBlock(world, pos.func_177968_d().func_177974_f());
        boolean southWest = south && west && this.isSameBlock(world, pos.func_177968_d().func_177976_e());
        TextureStyle ne = this.getStateFromBoolean(north, east, northEast);
        TextureStyle nw = this.getStateFromBoolean(north, west, northWest);
        TextureStyle se = this.getStateFromBoolean(south, east, southEast);
        TextureStyle sw = this.getStateFromBoolean(south, west, southWest);
        return state.func_177226_a(NORTH_EAST, (Comparable)((Object)ne)).func_177226_a(NORTH_WEST, (Comparable)((Object)nw)).func_177226_a(SOUTH_EAST, (Comparable)((Object)se)).func_177226_a(SOUTH_WEST, (Comparable)((Object)sw));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("harvestfestival:dirt", "ne=outer,nw=outer,se=outer,sw=outer"));
    }

    public static enum TextureStyle implements IStringSerializable
    {
        BLANK,
        INNER,
        VERTICAL,
        HORIZONTAL,
        OUTER;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

