/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import joshie.harvest.core.helpers.ChatHelper;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.MiningHelper;
import joshie.harvest.mining.render.ElevatorRender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TeleportPlayer {
    public static final Set<EntityPlayer> TELEPORTING = new HashSet<EntityPlayer>();
    private static final HashMap<EntityPlayer, TeleportPlayer> TELEPORTS = new HashMap();
    private final EntityPlayer player;
    private final World world;
    private final BlockPos origin;
    private final BlockPos pos;
    private final EnumFacing facing;
    private long lastUpdate;
    private int timer;

    public TeleportPlayer(BlockPos origin, EntityPlayer player, EnumFacing facing, BlockPos pos, int floors) {
        this.player = player;
        this.world = player.field_70170_p;
        this.pos = pos;
        this.timer = Math.min(600, Math.max(60, 15 * floors));
        this.facing = facing;
        this.origin = origin;
        if (this.world.field_72995_K) {
            ElevatorRender.ELEVATOR = true;
        } else {
            TELEPORTING.add(player);
        }
    }

    public static void initiate(EntityPlayer player, BlockPos twin, EnumFacing facing, BlockPos location) {
        if (player.field_70170_p.field_72995_K) {
            ElevatorRender.ELEVATOR = true;
        } else {
            TELEPORTING.add(player);
        }
        TeleportPlayer ticker = new TeleportPlayer(twin, player, facing, location, MiningHelper.getDifference((BlockPos)twin, (BlockPos)location));
        MinecraftForge.EVENT_BUS.register((Object)ticker);
        TELEPORTS.put(player, ticker);
    }

    public static void onCollide(EntityPlayer player) {
        TeleportPlayer teleporter = TELEPORTS.get(player);
        if (teleporter != null) {
            teleporter.onCollisionTick();
        }
    }

    private void finish() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        if (this.world.field_72995_K) {
            ElevatorRender.ELEVATOR = false;
        } else {
            TELEPORTS.remove(this.player);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_73011_w.getDimension() == HFMining.MINING_ID && event.world.func_82737_E() - this.lastUpdate > 1L) {
            this.finish();
        }
    }

    private void onCollisionTick() {
        if (this.world.func_82737_E() == this.lastUpdate) {
            return;
        }
        this.lastUpdate = this.world.func_82737_E();
        if (this.world.field_72995_K && this.timer % 20 == 0) {
            ChatHelper.displayChat("Please wait for " + this.timer / 20 + " seconds...");
        }
        --this.timer;
        if (this.timer <= 0) {
            this.finish();
            MiningHelper.teleportToCoordinates((Entity)this.player, (BlockPos)this.pos);
            this.player.field_70177_z = this.facing.func_185119_l();
            if (this.world.field_72995_K) {
                ElevatorRender.ELEVATOR = false;
                ChatHelper.displayChat("You have reached your destination!");
            } else {
                TELEPORTING.remove(this.player);
            }
        }
    }

    public static boolean isTeleporting(EntityPlayer player) {
        return player.field_70170_p.field_72995_K ? ElevatorRender.ELEVATOR : TELEPORTING.contains(player);
    }
}

