/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining;

import java.util.Random;
import joshie.harvest.api.ticking.IDailyTickableBlock;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.block.BlockFlower;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.MiningHelper;
import joshie.harvest.mining.block.BlockOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MiningTicker
implements IDailyTickableBlock {
    public static final int MYSTRIL_FLOOR = 150;
    public static final int GOLD_FLOOR = 80;
    public static final int SILVER_FLOOR = 40;
    private static final int MYSTRIL_CHANCE = 3000;
    private static final int GOLD_CHANCE = 1440;
    private static final int SILVER_CHANCE = 640;
    private static final int COPPER_CHANCE = 14;
    private static final double WORLD_HEIGHT = 256.0;
    static final int MAX_Y = 255;
    static final int FLOOR_HEIGHT = 6;
    static final int MAX_LOOP = 250;
    static final int MAX_FLOORS = (int)Math.floor(42.666666666666664);

    public static IBlockState getBlockState(Random rand, int floor) {
        BlockOre.Ore ore = BlockOre.Ore.ROCK;
        if (rand.nextInt(24) == 0) {
            return HFCore.FLOWERS.getStateFromEnum(BlockFlower.FlowerType.WEED);
        }
        if (floor >= 150 && rand.nextInt(3000) <= floor) {
            ore = BlockOre.Ore.MYSTRIL;
        } else if (floor >= 80 && rand.nextInt(1440) <= floor) {
            ore = BlockOre.Ore.GOLD;
        } else if (floor >= 40 && rand.nextInt(640) <= floor) {
            ore = BlockOre.Ore.SILVER;
        } else if (rand.nextInt(14) == 0) {
            ore = BlockOre.Ore.COPPER;
        }
        return HFMining.ORE.getStateFromEnum(ore);
    }

    @Override
    public boolean isMiningWorld() {
        return true;
    }

    @Override
    public boolean newDay(World world, BlockPos pos, IBlockState state) {
        BlockPos up = pos.func_177984_a();
        IBlockState above = world.func_180495_p(up);
        if (above.func_177230_c() == Blocks.field_150350_a) {
            int floor = MiningHelper.getFloor(world.func_175726_f((BlockPos)pos).field_76635_g, pos.func_177956_o());
            if (world.field_73012_v.nextInt(32) == 0) {
                world.func_175656_a(up, HFCore.FLOWERS.getStateFromEnum(BlockFlower.FlowerType.WEED));
            } else {
                world.func_175656_a(up, MiningTicker.getBlockState(world.field_73012_v, floor));
            }
        }
        return true;
    }
}

