/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining;

import java.util.List;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.util.Direction;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.MiningProvider;
import joshie.harvest.mining.MiningTicker;
import joshie.harvest.mining.block.BlockPortal;
import joshie.harvest.town.TownTracker;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class MiningHelper {
    public static ItemStack getLoot(ResourceLocation loot, World world, EntityPlayer player, float luck) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)world);
        lootcontext$builder.func_186469_a(player.func_184817_da() + luck);
        lootcontext$builder.func_186470_a(player);
        List stacks = world.func_184146_ak().func_186521_a(loot).func_186462_a(world.field_73012_v, lootcontext$builder.func_186471_a());
        return stacks.size() > 0 ? (ItemStack)stacks.get(0) : null;
    }

    public static int getMineID(int chunkZ) {
        return (int)Math.floor(chunkZ / 10);
    }

    private static void preloadChunks(WorldServer worldServer, int mineID, int floor) {
        MiningProvider provider = (MiningProvider)worldServer.field_73011_w;
        if (!provider.areCoordinatesGenerated(mineID, floor)) {
            int xStart = (int)Math.floor((floor - 1) / MiningTicker.MAX_FLOORS);
            for (int x = xStart * 10; x < xStart * 10 + 10; ++x) {
                for (int z = mineID * 10; z < mineID * 10 + 10; ++z) {
                    worldServer.func_72863_F().func_186025_d(x, z);
                }
            }
            if (worldServer instanceof WorldServerMulti) {
                ((WorldServerMulti)worldServer).func_184166_c();
            }
        }
    }

    private static boolean isSpawnable(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176205_b((IBlockAccess)world, pos);
    }

    private static BlockPos modifySpawnAndPlayerRotation(WorldServer dim, BlockPos spawn, Entity entity) {
        IBlockState actual = HFMining.PORTAL.func_176221_a(dim.func_180495_p(spawn), (IBlockAccess)dim, spawn);
        if (actual.func_177230_c() == HFMining.PORTAL) {
            BlockPortal.Portal portal = (BlockPortal.Portal)((Object)HFMining.PORTAL.getEnumFromState(actual));
            for (int distance = 2; distance < 9; ++distance) {
                if (portal.isEW()) {
                    if (MiningHelper.isSpawnable((World)dim, spawn.func_177964_d(distance))) {
                        entity.field_70177_z = 180.0f;
                        return spawn.func_177964_d(distance);
                    }
                    if (!MiningHelper.isSpawnable((World)dim, spawn.func_177970_e(distance))) continue;
                    entity.field_70177_z = 0.0f;
                    return spawn.func_177970_e(distance);
                }
                if (MiningHelper.isSpawnable((World)dim, spawn.func_177965_g(distance))) {
                    entity.field_70177_z = 270.0f;
                    return spawn.func_177965_g(distance);
                }
                if (!MiningHelper.isSpawnable((World)dim, spawn.func_177985_f(distance))) continue;
                entity.field_70177_z = 90.0f;
                return spawn.func_177985_f(distance);
            }
        }
        return spawn;
    }

    public static boolean teleportToMine(Entity entity) {
        int id = ((TownTracker)HFTrackers.getTownTracker(entity.field_70170_p)).getMineIDFromCoordinates(new BlockPos(entity));
        return id != -1 && MiningHelper.teleportToMine(entity, id);
    }

    public static boolean teleportToMine(Entity entity, int mineID) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer newWorld = server.func_71218_a(HFMining.MINING_ID);
        MiningHelper.preloadChunks(newWorld, mineID, 1);
        BlockPos spawn = MiningHelper.modifySpawnAndPlayerRotation(newWorld, ((MiningProvider)newWorld.field_73011_w).getSpawnCoordinateForMine(mineID, 1), entity);
        return EntityHelper.teleport(entity, HFMining.MINING_ID, spawn);
    }

    public static boolean teleportToOverworld(Entity entity) {
        int mineID = MiningHelper.getMineID((int)entity.field_70161_v >> 4);
        Object tracker = HFTrackers.getTownTracker((World)DimensionManager.getWorld((int)0));
        BlockPos spawn = ((TownTracker)tracker).getCoordinatesForOverworldMine(entity, mineID);
        Direction direction = ((TownTracker)tracker).getMineOrientation(mineID);
        if (spawn == null) {
            spawn = entity.field_70170_p.func_175694_M();
        }
        if (direction.getRotation() == Rotation.NONE) {
            entity.field_70177_z = 90.0f;
        } else if (direction.getRotation() == Rotation.CLOCKWISE_90) {
            entity.field_70177_z = 180.0f;
        } else if (direction.getRotation() == Rotation.CLOCKWISE_180) {
            entity.field_70177_z = 270.0f;
        } else if (direction.getRotation() == Rotation.COUNTERCLOCKWISE_90) {
            entity.field_70177_z = 0.0f;
        }
        return EntityHelper.teleport(entity, 0, spawn);
    }

    public static boolean teleportBetweenMine(Entity entity) {
        int mineID = MiningHelper.getMineID((int)entity.field_70161_v >> 4);
        int floor = MiningHelper.getFloor((int)entity.field_70165_t >> 4, (int)entity.field_70163_u);
        boolean top = floor % MiningTicker.MAX_FLOORS == 1;
        int newFloor = top ? floor - 1 : floor + 1;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer newWorld = server.func_71218_a(HFMining.MINING_ID);
        MiningHelper.preloadChunks(newWorld, mineID, newFloor);
        BlockPos spawn = MiningHelper.modifySpawnAndPlayerRotation(newWorld, ((MiningProvider)newWorld.field_73011_w).getSpawnCoordinateForMine(mineID, newFloor), entity);
        if (entity.field_71088_bW == 0) {
            entity.field_71088_bW = 100;
            if (entity instanceof EntityPlayerMP) {
                ReflectionHelper.setPrivateValue(EntityPlayerMP.class, (Object)((EntityPlayerMP)entity), (Object)true, (String[])new String[]{"invulnerableDimensionChange", "field_184851_cj"});
            }
            entity.func_70634_a((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 0.1, (double)spawn.func_177952_p() + 0.5);
        }
        return true;
    }

    public static int getFloor(int xPosition, int posY) {
        int chunkIndex = (int)Math.floor((double)xPosition / 10.0);
        int floorIndex = (int)((double)MiningTicker.MAX_FLOORS - Math.floor((double)posY / 6.0));
        return chunkIndex * MiningTicker.MAX_FLOORS + floorIndex;
    }
}

