/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining;

import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.MiningHelper;
import joshie.harvest.mining.MiningTicker;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@HFEvents
public class MiningDaily {
    private void removeOresAndSpawnNew(World world, Chunk chunk) {
        int loopY;
        ExtendedBlockStorage[] array = chunk.func_76587_i();
        for (loopY = 0; loopY < 250; loopY += 6) {
            int y = loopY + 1;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    ExtendedBlockStorage extendedblockstorage = array[y >> 4];
                    if (extendedblockstorage == Chunk.field_186036_a || extendedblockstorage.func_177485_a(x, y & 0xF, z).func_177230_c() != HFMining.ORE) continue;
                    extendedblockstorage.func_177484_a(x, y & 0xF, z, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        for (loopY = 0; loopY < 250; loopY += 6) {
            int oreChance = world.field_73012_v.nextInt(5) == 0 ? 10 + world.field_73012_v.nextInt(15) : 25 + world.field_73012_v.nextInt(25);
            int floor = MiningHelper.getFloor(chunk.field_76635_g, loopY);
            int y = loopY + 1;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    IBlockState set;
                    IBlockState state;
                    ExtendedBlockStorage extendedblockstorage;
                    if (world.field_73012_v.nextInt(oreChance) != 0 || (extendedblockstorage = array[y >> 4]) == Chunk.field_186036_a || (state = extendedblockstorage.func_177485_a(x, y & 0xF, z)).func_177230_c() != Blocks.field_150350_a || (set = MiningTicker.getBlockState(world.field_73012_v, floor)) == null) continue;
                    extendedblockstorage.func_177484_a(x, y & 0xF, z, set);
                }
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        if (event.getWorld().field_73011_w.getDimension() == HFMining.MINING_ID) {
            int lastDay;
            int days;
            NBTTagCompound tag = this.getCompoundTag(event.getData());
            long chunk = ChunkPos.func_77272_a((int)event.getChunk().field_76635_g, (int)event.getChunk().field_76647_h);
            if (tag.func_74764_b("" + chunk) && (days = CalendarHelper.getElapsedDays(event.getWorld().func_72820_D())) - (lastDay = tag.func_74762_e("" + chunk)) > 0) {
                this.removeOresAndSpawnNew(event.getWorld(), event.getChunk());
            }
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() == HFMining.MINING_ID) {
            NBTTagCompound tag = this.getCompoundTag(event.getData());
            long chunk = ChunkPos.func_77272_a((int)event.getChunk().field_76635_g, (int)event.getChunk().field_76647_h);
            int days = CalendarHelper.getElapsedDays(event.getWorld().func_72820_D());
            tag.func_74768_a("" + chunk, days);
        }
    }

    private NBTTagCompound getCompoundTag(NBTTagCompound tag) {
        if (tag.func_74764_b("LastTickData")) {
            return tag.func_74775_l("LastTickData");
        }
        NBTTagCompound data = new NBTTagCompound();
        tag.func_74782_a("LastTickData", (NBTBase)data);
        return data;
    }
}

