/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining;

import com.google.common.collect.Lists;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.MineManager;
import joshie.harvest.mining.MiningHelper;
import joshie.harvest.mining.MiningTicker;
import joshie.harvest.mining.entity.EntityDarkChick;
import joshie.harvest.mining.entity.EntityDarkChicken;
import joshie.harvest.mining.entity.EntityDarkCow;
import joshie.harvest.mining.entity.EntityDarkSheep;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;

public class MiningChunk
implements IChunkGenerator {
    private final Random rand;
    private static final IBlockState WALLS = HFMining.STONE.func_176223_P();
    private static final IBlockState FLOORS = HFMining.DIRT.func_176223_P();
    private static final IBlockState LADDER = HFMining.LADDER.func_176223_P();
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final IBlockState PORTAL = HFMining.PORTAL.func_176223_P();
    private static final IBlockState ORE = HFMining.ORE.func_176223_P();
    protected static final List<Biome.SpawnListEntry> MONSTERS = Lists.newArrayList();
    protected static final List<Block> IRREPLACABLE = Lists.newArrayList();
    private final World worldObj;
    private Biome[] biomesForGeneration;

    public MiningChunk(World world, long seed) {
        this.worldObj = world;
        this.rand = new Random(seed);
    }

    public void setBlockState(ChunkPrimer primer, int x, int y, int z, IBlockState state, int chunkX, int chunkZ) {
        x = Math.min(15, Math.max(0, x));
        y = Math.min(255, Math.max(0, y));
        z = Math.min(15, Math.max(0, z));
        if (state.func_177230_c() == PORTAL.func_177230_c()) {
            primer.func_177855_a(x, y, z, state);
        } else if (state.func_177230_c() == ORE.func_177230_c()) {
            if (primer.func_177856_a(x, y, z).func_177230_c() != Blocks.field_150468_ap && primer.func_177856_a(x, y, z).func_177230_c() != PORTAL.func_177230_c()) {
                primer.func_177855_a(x, y, z, FLOORS);
                if (primer.func_177856_a(x, y + 1, z).func_177230_c() != Blocks.field_150468_ap) {
                    primer.func_177855_a(x, y + 1, z, MiningTicker.getBlockState(this.rand, MiningHelper.getFloor(chunkX, y)));
                }
            }
        } else {
            Block block = primer.func_177856_a(x, y, z).func_177230_c();
            if (!IRREPLACABLE.contains(block) && state == AIR || state != AIR) {
                primer.func_177855_a(x, y, z, state);
            }
        }
    }

    public IBlockState getBlockState(ChunkPrimer primer, int x, int y, int z) {
        x = Math.min(15, Math.max(0, x));
        y = Math.min(255, Math.max(0, y));
        z = Math.min(15, Math.max(0, z));
        return primer.func_177856_a(x, y, z);
    }

    private boolean isFloorWithPortal(int floor) {
        return floor % MiningTicker.MAX_FLOORS == 1 || floor % MiningTicker.MAX_FLOORS == 0;
    }

    private void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        int chunkY;
        int k;
        int i;
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (k = 0; k < 255; ++k) {
                    this.setBlockState(primer, i, k, j, WALLS, chunkX, chunkZ);
                }
            }
        }
        if (chunkX >= 0 && chunkZ >= 0) {
            for (chunkY = 0; chunkY < 250; chunkY += 6) {
                IBlockState[][] below;
                IBlockState[][] states = this.getMineGeneration(chunkX, chunkY, chunkZ);
                this.rand.setSeed((long)this.getIndex(chunkX, chunkY, chunkZ) * this.worldObj.func_72905_C());
                for (int i2 = 0; i2 < 16; ++i2) {
                    for (int j = 0; j < 16; ++j) {
                        if (states[i2][j] != FLOORS && states[i2][j] != ORE) continue;
                        this.setBlockState(primer, i2, chunkY, j, states[i2][j], chunkX, chunkZ);
                        for (int k2 = 0; k2 < 3; ++k2) {
                            int width = 1 + this.rand.nextInt(1);
                            int length = 1 + this.rand.nextInt(1);
                            for (int x4 = -width; x4 <= width; ++x4) {
                                block8: for (int z4 = -length; z4 < length; ++z4) {
                                    for (EnumFacing enumFacing : EnumFacing.values()) {
                                        if (enumFacing == EnumFacing.DOWN || enumFacing == EnumFacing.UP) continue;
                                        BlockPos pos = new BlockPos(i2 + x4, chunkY, j + z4);
                                        BlockPos offset = pos.func_177972_a(enumFacing);
                                        if (x4 == z4 || this.getBlockState(primer, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p()) != states[i2][j] || !this.rand.nextBoolean()) continue;
                                        this.setBlockState(primer, pos.func_177958_n(), chunkY, pos.func_177952_p(), states[i2][j], chunkX, chunkZ);
                                        for (int y = 1; y <= 4; ++y) {
                                            this.setBlockState(primer, pos.func_177958_n(), chunkY + y, pos.func_177952_p(), AIR, chunkX, chunkZ);
                                        }
                                        continue block8;
                                    }
                                }
                            }
                        }
                        for (int y = 1; y <= 4; ++y) {
                            this.setBlockState(primer, i2, chunkY + y, j, AIR, chunkX, chunkZ);
                        }
                    }
                }
                int belowY = chunkY - 6;
                IBlockState[][] iBlockStateArray = below = chunkY == 0 ? (IBlockState[][])null : this.getMineGeneration(chunkX, belowY, chunkZ);
                if (below == null) continue;
                for (int i3 = 0; i3 < 16; ++i3) {
                    for (int j = 0; j < 16; ++j) {
                        if (below[i3][j] != LADDER) continue;
                        Rotation rotation = Rotation.values()[this.rand.nextInt(Rotation.values().length)];
                        IBlockState theState = HFMining.LADDER.func_185499_a(LADDER, rotation);
                        if (this.getBlockState(primer, i3, belowY, j).func_177230_c() != LADDER.func_177230_c()) {
                            this.setBlockState(primer, i3, belowY, j, FLOORS, chunkX, chunkZ);
                        }
                        for (int y = 1; y <= 6; ++y) {
                            this.setBlockState(primer, i3, belowY + y, j, theState, chunkX, chunkZ);
                            this.setBlockState(primer, i3, belowY + y + 4, j, AIR, chunkX, chunkZ);
                        }
                    }
                }
            }
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (k = 0; k < 255; ++k) {
                    this.setBlockState(primer, i, 251, j, WALLS, chunkX, chunkZ);
                }
            }
        }
        for (chunkY = 0; chunkY < 250; chunkY += 6) {
            int mineID = MiningHelper.getMineID(chunkZ);
            int floor = MiningHelper.getFloor(chunkX, chunkY);
            if (floor == 0 || !this.isFloorWithPortal(floor) || MineManager.areCoordinatesGenerated(this.worldObj, mineID, floor)) continue;
            this.placePortals(primer, mineID, floor, chunkX, chunkY, chunkZ);
        }
    }

    private void placePortals(ChunkPrimer primer, int mineID, int floor, int chunkX, int chunkY, int chunkZ) {
        if (this.isFloorWithPortal(floor) && !MineManager.areCoordinatesGenerated(this.worldObj, mineID, floor)) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (this.isXLineWall(primer, x, chunkY + 1, z) && this.isXLineAir(primer, x, chunkY + 1, z)) {
                        this.setXSpawn(floor, primer, x, chunkY + 1, z, chunkX, chunkZ);
                        return;
                    }
                    if (!this.isZLineWall(primer, x, chunkY + 1, z) || !this.isZLineAir(primer, x, chunkY + 1, z)) continue;
                    this.setZSpawn(floor, primer, x, chunkY + 1, z, chunkX, chunkZ);
                    return;
                }
            }
        }
    }

    private void setXSpawn(int floor, ChunkPrimer primer, int x, int y, int z, int chunkX, int chunkZ) {
        int realX = chunkX * 16 + x;
        int realZ = chunkZ * 16 + z;
        this.setBlockState(primer, x, y, z, PORTAL, chunkX, chunkZ);
        this.setBlockState(primer, x - 1, y, z, PORTAL, chunkX, chunkZ);
        this.setBlockState(primer, x + 1, y, z, PORTAL, chunkX, chunkZ);
        this.setBlockState(primer, x, y + 1, z, PORTAL, chunkX, chunkZ);
        this.setBlockState(primer, x - 1, y + 1, z, PORTAL, chunkX, chunkZ);
        this.setBlockState(primer, x + 1, y + 1, z, PORTAL, chunkX, chunkZ);
        HFTrackers.getMineManager(this.worldObj).setSpawnForMine(MiningHelper.getMineID(chunkZ), floor, realX, y, realZ);
    }

    private void setZSpawn(int floor, ChunkPrimer primer, int x, int y, int z, int chunkX, int chunkZ) {
        int realX = chunkX * 16 + x;
        int realZ = chunkZ * 16 + z;
        this.setBlockState(primer, x, y, z, PORTAL, chunkX, chunkZ);
        this.setBlockState(primer, x, y, z - 1, PORTAL, chunkX, chunkZ);
        this.setBlockState(primer, x, y, z + 1, PORTAL, chunkX, chunkZ);
        this.setBlockState(primer, x, y + 1, z, PORTAL, chunkX, chunkZ);
        this.setBlockState(primer, x, y + 1, z - 1, PORTAL, chunkX, chunkZ);
        this.setBlockState(primer, x, y + 1, z + 1, PORTAL, chunkX, chunkZ);
        HFTrackers.getMineManager(this.worldObj).setSpawnForMine(MiningHelper.getMineID(chunkZ), floor, realX, y, realZ);
    }

    private boolean isXLineWall(ChunkPrimer primer, int x, int y, int z) {
        return x + 1 < 16 && x - 1 >= 0 && this.getBlockState(primer, x, y, z) == WALLS && this.getBlockState(primer, x + 1, y, z) == WALLS && this.getBlockState(primer, x - 1, y, z) == WALLS;
    }

    private boolean isXLineAir(ChunkPrimer primer, int x, int y, int z) {
        return z + 1 < 16 && this.getBlockState(primer, x, y, z + 1) == AIR && this.getBlockState(primer, x + 1, y, z + 1) == AIR && this.getBlockState(primer, x - 1, y, z + 1) == AIR || z - 1 >= 0 && this.getBlockState(primer, x, y, z - 1) == AIR && this.getBlockState(primer, x + 1, y, z - 1) == AIR && this.getBlockState(primer, x - 1, y, z - 1) == AIR;
    }

    private boolean isZLineWall(ChunkPrimer primer, int x, int y, int z) {
        return z + 1 < 16 && z - 1 >= 0 && this.getBlockState(primer, x, y, z) == WALLS && this.getBlockState(primer, x, y, z + 1) == WALLS && this.getBlockState(primer, x, y, z - 1) == WALLS;
    }

    private boolean isZLineAir(ChunkPrimer primer, int x, int y, int z) {
        return x + 1 < 16 && this.getBlockState(primer, x + 1, y, z) == AIR && this.getBlockState(primer, x + 1, y, z + 1) == AIR && this.getBlockState(primer, x + 1, y, z - 1) == AIR || x - 1 >= 16 && this.getBlockState(primer, x - 1, y, z) == AIR && this.getBlockState(primer, x - 1, y, z + 1) == AIR && this.getBlockState(primer, x - 1, y, z - 1) == AIR;
    }

    private int clamp(int number) {
        return Math.max(0, Math.min(159, number));
    }

    private int getChunkIndexFromCoordinates(int chunkXIndex, int chunkZIndex) {
        return chunkXIndex + chunkZIndex * 10;
    }

    private IBlockState[][] getBooleanFromMap(TIntObjectMap<IBlockState[][]> map, int index) {
        map.putIfAbsent(index, (Object)new IBlockState[16][16]);
        return (IBlockState[][])map.get(index);
    }

    private int getIndex(int chunkX, int chunkY, int chunkZ) {
        int x = (int)Math.floor(chunkX / 10);
        int y = (int)Math.floor(chunkY / 6);
        int z = (int)Math.floor(chunkZ / 10);
        int result = x;
        result = 31 * result + z;
        result = 31 * result + y;
        return result;
    }

    private IBlockState[][] getMineGeneration(int chunkX, int chunkY, int chunkZ) {
        int mapIndex = this.getIndex(chunkX, chunkY, chunkZ);
        if (!MineManager.containsStateKey(mapIndex)) {
            IBlockState[][] blockStateMap = new IBlockState[160][160];
            boolean first = true;
            this.rand.setSeed((long)mapIndex * this.worldObj.func_72905_C());
            int startX = 15 + this.rand.nextInt(85);
            int endX = 15 + this.rand.nextInt(85);
            int startZ = 15 + this.rand.nextInt(85);
            int endZ = 15 + this.rand.nextInt(85);
            int ladderDistance = 5 + this.rand.nextInt(25);
            int differenceMin = 5 + this.rand.nextInt(15);
            int endDistance = differenceMin * 3 - 1;
            int maxLoop = 1 + this.rand.nextInt(5);
            int endChangeChanceX = 15 + this.rand.nextInt(15);
            int endChangeChanceZ = 15 + this.rand.nextInt(15);
            int changeMinX = 10 + this.rand.nextInt(25);
            int changeMinZ = 10 + this.rand.nextInt(25);
            int randXChange = 5 + this.rand.nextInt(30);
            int randZChange = 5 + this.rand.nextInt(30);
            int randXTime = 7 + this.rand.nextInt(10);
            int randZTime = 7 + this.rand.nextInt(10);
            int radius = 1 + this.rand.nextInt(3);
            int oreChance = this.rand.nextInt(5) == 0 ? 10 + this.rand.nextInt(15) : 25 + this.rand.nextInt(25);
            for (int k = 0; k < maxLoop; ++k) {
                int differenceZ;
                if (first) {
                    first = false;
                } else {
                    startX = endX;
                    startZ = endZ;
                }
                int differenceX = startX > endX ? startX - endX : endX - startX;
                int n = differenceZ = startZ > endZ ? startZ - endZ : endZ - startZ;
                while (endX == endZ || differenceX < differenceMin || differenceZ < differenceMin) {
                    endX = this.rand.nextInt(endDistance);
                    endZ = this.rand.nextInt(endDistance);
                    differenceX = startX > endX ? startX - endX : endX - startX;
                    differenceZ = startZ > endZ ? startZ - endZ : endZ - startZ;
                }
                if (chunkY != 0 && MineManager.containsCoordinatesKey(this.getIndex(chunkX, chunkY - 6, chunkZ))) {
                    int below = this.getIndex(chunkX, chunkY - 6, chunkZ);
                    startX = MineManager.getCoordinates(below, 0);
                    startZ = MineManager.getCoordinates(below, 1);
                }
                if (startX == -1 || endX == -1 || startZ == -1 || endZ == -1) continue;
                blockStateMap[startX][startZ] = FLOORS;
                for (int i = -radius; i <= radius; ++i) {
                    for (int l = -radius; l <= radius; ++l) {
                        IBlockState state;
                        if ((float)(i * i + l * l) >= ((float)radius + 0.5f) * ((float)radius + 0.5f)) continue;
                        int x = startX + i;
                        int z = startZ + l;
                        int x2 = this.clamp(x);
                        int z2 = this.clamp(z);
                        blockStateMap[x2][z2] = state = this.rand.nextInt(oreChance) == 0 ? ORE : FLOORS;
                    }
                }
                int x = startX;
                int z = startZ;
                int sameXTime = 0;
                int sameZTime = 0;
                block4: while (x != endX || z != endZ) {
                    int option = this.rand.nextInt(4);
                    if (option == 0) {
                        if (x < endX) {
                            ++x;
                        }
                    } else if (option == 1) {
                        if (x > endX) {
                            --x;
                        }
                    } else if (option == 2) {
                        if (z < endZ) {
                            ++z;
                        }
                    } else if (option == 3 && z > endZ) {
                        --z;
                    }
                    if (blockStateMap[this.clamp(x)][this.clamp(z)] != LADDER) {
                        IBlockState state;
                        blockStateMap[this.clamp((int)x)][this.clamp((int)z)] = state = this.rand.nextInt(oreChance) == 0 ? ORE : FLOORS;
                    }
                    if ((option = this.rand.nextInt(16)) == 0) {
                        if (x > endX) {
                            ++x;
                        }
                    } else if (option == 1) {
                        if (x < endX) {
                            --x;
                        }
                    } else if (option == 2) {
                        if (z > endZ) {
                            ++z;
                        }
                    } else if (option == 3 && z < endZ) {
                        --z;
                    }
                    if (blockStateMap[this.clamp(x)][this.clamp(z)] != LADDER) {
                        IBlockState state;
                        blockStateMap[this.clamp((int)x)][this.clamp((int)z)] = state = this.rand.nextInt(oreChance) == 0 ? ORE : FLOORS;
                    }
                    boolean regenEndX = false;
                    boolean regenEndZ = false;
                    if (x == endX && ++sameXTime >= randXTime) {
                        sameXTime = 0;
                        regenEndX = true;
                    }
                    if (z == endZ && ++sameZTime >= randZTime) {
                        sameZTime = 0;
                        regenEndZ = true;
                    }
                    if (regenEndX || this.rand.nextInt(endChangeChanceX) == 0) {
                        endX = changeMinX + this.rand.nextInt(randXChange);
                    }
                    if (regenEndZ || this.rand.nextInt(endChangeChanceZ) == 0) {
                        endZ = changeMinZ + this.rand.nextInt(randZChange);
                    }
                    int x2 = this.clamp(x);
                    int z2 = this.clamp(z);
                    for (EnumFacing enumfacing : EnumFacing.values()) {
                        if (enumfacing == EnumFacing.DOWN || enumfacing == EnumFacing.UP) continue;
                        BlockPos pos = new BlockPos(x, chunkY, z).func_177972_a(enumfacing);
                        int x3 = this.clamp(pos.func_177958_n());
                        int z3 = this.clamp(pos.func_177952_p());
                        if (pos.func_177958_n() < 0 || pos.func_177958_n() >= blockStateMap.length || pos.func_177952_p() < 0 || pos.func_177952_p() >= blockStateMap[pos.func_177958_n()].length || blockStateMap[x3][z3] != FLOORS && blockStateMap[x3][z3] != ORE) continue;
                        int wStart = this.rand.nextInt(2);
                        int wEnd = this.rand.nextInt(2);
                        int lStart = this.rand.nextInt(2);
                        int lEnd = this.rand.nextInt(2);
                        for (int x4 = -wStart; x4 <= wEnd; ++x4) {
                            for (int z4 = -lStart; z4 <= lEnd; ++z4) {
                                IBlockState state;
                                if (x4 == z4 || blockStateMap[this.clamp(x2 + x4)][this.clamp(z2 + z4)] == LADDER) continue;
                                blockStateMap[this.clamp((int)(x2 + x4))][this.clamp((int)(z2 + z4))] = state = this.rand.nextInt(oreChance) == 0 ? ORE : FLOORS;
                                differenceX = startX > x ? startX - x : x - startX;
                                int n2 = differenceZ = startZ > z ? startZ - z : z - startZ;
                                if (differenceX < ladderDistance && differenceZ < ladderDistance || MineManager.containsCoordinatesKey(mapIndex)) continue;
                                int clampedX = this.clamp(x2 + x4);
                                int clampedZ = this.clamp(z2 + z4);
                                blockStateMap[clampedX][clampedZ] = LADDER;
                                for (int x5 = -1; x5 <= 1; ++x5) {
                                    for (int z5 = -1; z5 <= 1; ++z5) {
                                        int clampedZ5;
                                        int clampedX5 = this.clamp(clampedX + x5);
                                        if (blockStateMap[clampedX5][clampedZ5 = this.clamp(clampedZ + z5)] == LADDER) continue;
                                        blockStateMap[clampedX5][clampedZ5] = FLOORS;
                                    }
                                }
                                MineManager.putCoordinates(mapIndex, new int[]{clampedX, clampedZ});
                            }
                        }
                        continue block4;
                    }
                }
                if (MineManager.containsCoordinatesKey(mapIndex) || k != maxLoop - 1) continue;
                blockStateMap[startX][startZ] = LADDER;
                MineManager.putCoordinates(mapIndex, new int[]{startX, startZ});
            }
            TIntObjectHashMap stateMap = new TIntObjectHashMap();
            for (int cX = 0; cX < blockStateMap.length; ++cX) {
                for (int cZ = 0; cZ < blockStateMap[cX].length; ++cZ) {
                    int chunkIndexX = (int)Math.floor(cX / 16);
                    int chunkIndexZ = (int)Math.floor(cZ / 16);
                    int chunkIndex = this.getChunkIndexFromCoordinates(chunkIndexX, chunkIndexZ);
                    IBlockState[][] air = this.getBooleanFromMap((TIntObjectMap<IBlockState[][]>)stateMap, chunkIndex);
                    air[cX % 16][cZ % 16] = blockStateMap[cX][cZ];
                    stateMap.put(chunkIndex, (Object)air);
                }
            }
            MineManager.putStateMap(mapIndex, (TIntObjectMap<IBlockState[][]>)stateMap);
        }
        TIntObjectMap<IBlockState[][]> map = MineManager.getStateMap(mapIndex);
        int chunkXIndex = chunkX % 10;
        int chunkZIndex = chunkZ % 10;
        int checkIndex = this.getChunkIndexFromCoordinates(chunkXIndex, chunkZIndex);
        return (IBlockState[][])map.get(checkIndex);
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.setBlocksInChunk(x, z, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            return MONSTERS;
        }
        return this.worldObj.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    static {
        MONSTERS.add(new Biome.SpawnListEntry(EntityDarkChick.class, 100, 1, 5));
        MONSTERS.add(new Biome.SpawnListEntry(EntityDarkChicken.class, 50, 1, 3));
        MONSTERS.add(new Biome.SpawnListEntry(EntityDarkSheep.class, 30, 1, 2));
        MONSTERS.add(new Biome.SpawnListEntry(EntityDarkCow.class, 15, 1, 1));
        IRREPLACABLE.add(ORE.func_177230_c());
        IRREPLACABLE.add(HFCore.FLOWERS);
        IRREPLACABLE.add(HFMining.PORTAL);
    }
}

