/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import joshie.harvest.api.WorldLocation;
import joshie.harvest.buildings.placeable.blocks.PlaceableBlock;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.mining.MineTracker;
import joshie.harvest.mining.data.Mine;
import joshie.harvest.mining.data.MineData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MineTrackerServer
extends MineTracker {
    public static HashMap<WorldLocation, MineData> map = new HashMap();
    public static HashSet<Mine> mines = new HashSet();

    @Override
    public void newDay() {
        for (Mine mine : mines) {
            mine.newDay();
        }
    }

    private WorldLocation getKey(World world, BlockPos pos) {
        return new WorldLocation(world.field_73011_w.getDimension(), pos);
    }

    @Override
    public void completeMine(World world, BlockPos pos, ArrayList<PlaceableBlock> blocks) {
        WorldLocation key = this.getKey(world, pos);
        MineData data = map.get(key);
        data.getMine().complete(world, pos, blocks);
        HFTrackers.markDirty();
    }

    @Override
    public void destroyLevel(World world, BlockPos pos) {
        WorldLocation key = this.getKey(world, pos);
        MineData data = map.get(key);
        if (data == null || data.getLevel() == null) {
            return;
        }
        data.getLevel().destroy();
        HFTrackers.markDirty();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList mine = nbt.func_150295_c("Mines", 10);
        for (int i = 0; i < mine.func_74745_c(); ++i) {
            NBTTagCompound tag = mine.func_150305_b(i);
            Mine m = new Mine();
            m.readFromNBT(tag);
            mines.add(m);
        }
        NBTTagList mapping = nbt.func_150295_c("MineMappings", 10);
        for (int i = 0; i < mapping.func_74745_c(); ++i) {
            NBTTagCompound tag = mapping.func_150305_b(i);
            WorldLocation location = new WorldLocation();
            location.readFromNBT(tag);
            MineData data = new MineData();
            data.readFromNBT(tag);
            map.put(location, data);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList mine = new NBTTagList();
        for (Mine m : mines) {
            NBTTagCompound tag = new NBTTagCompound();
            m.writeToNBT(tag);
            mine.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Mines", (NBTBase)mine);
        NBTTagList mapping = new NBTTagList();
        for (Map.Entry<WorldLocation, MineData> entry : map.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            entry.getKey().writeToNBT(tag);
            entry.getValue().writeToNBT(tag);
            mapping.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("MineMappings", (NBTBase)mapping);
    }
}

