/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.mining;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.MiningTicker;
import joshie.harvest.mining.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

@HFEvents
public class MineManager
extends WorldSavedData {
    public static final int CHUNK_BOUNDARY = 10;
    private static final TIntObjectMap<TIntObjectMap<IBlockState[][]>> generation = new TIntObjectHashMap();
    private static final TIntObjectMap<int[]> coordinates = new TIntObjectHashMap();
    private TIntObjectMap<TIntObjectMap<BlockPos>> portalCoordinates = new TIntObjectHashMap();

    public MineManager(String string) {
        super(string);
    }

    public void func_76184_a(NBTTagCompound tag) {
        this.portalCoordinates = NBTHelper.readPositionCollection(tag.func_150295_c("PortalCoordinates", 10));
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        tag.func_74782_a("PortalCoordinates", (NBTBase)NBTHelper.writePositionCollection(this.portalCoordinates));
        return tag;
    }

    public static boolean areCoordinatesGenerated(World world, int mineID, int floor) {
        return HFTrackers.getMineManager(world).getCoordinateMap(mineID).containsKey(floor);
    }

    public BlockPos getSpawnCoordinateForMine(World world, int mineID, int floor) {
        BlockPos ret = (BlockPos)this.getCoordinateMap(mineID).get(floor);
        if (ret == null) {
            BlockPos pos = new BlockPos(Math.floor(floor / MiningTicker.MAX_FLOORS) * 10.0 * 16.0, (floor - 1) % MiningTicker.MAX_FLOORS == 0 ? 247.0 : 1.0, (double)(mineID * 10 * 16));
            for (int x = 0; x < 160; ++x) {
                for (int z = 0; z < 160; ++z) {
                    BlockPos toCheck = pos.func_177982_a(x, 0, z);
                    IBlockState state = world.func_180495_p(toCheck);
                    if (state.func_177230_c() != HFMining.PORTAL || !((BlockPortal.Portal)((Object)state.func_185899_b((IBlockAccess)world, toCheck).func_177229_b((IProperty)HFMining.PORTAL.property))).isCentre()) continue;
                    return toCheck;
                }
            }
            return new BlockPos(0, 254, mineID * 10 * 16);
        }
        return ret;
    }

    private TIntObjectMap<BlockPos> getCoordinateMap(int mineID) {
        TIntObjectMap map = (TIntObjectMap)this.portalCoordinates.get(mineID);
        if (map == null) {
            map = new TIntObjectHashMap();
            this.portalCoordinates.put(mineID, (Object)map);
        }
        return map;
    }

    public void setSpawnForMine(int mineID, int floor, int x, int y, int z) {
        this.getCoordinateMap(mineID).putIfAbsent(floor, (Object)new BlockPos(x, y, z));
        this.func_76185_a();
    }

    static TIntObjectMap<IBlockState[][]> getStateMap(int mapIndex) {
        return (TIntObjectMap)generation.get(mapIndex);
    }

    static void putStateMap(int mapIndex, TIntObjectMap<IBlockState[][]> map) {
        generation.put(mapIndex, map);
    }

    static boolean containsStateKey(int mapIndex) {
        return generation.containsKey(mapIndex);
    }

    static boolean containsCoordinatesKey(int mapIndex) {
        return coordinates.containsKey(mapIndex);
    }

    static void putCoordinates(int mapIndex, int[] coordinates) {
        MineManager.coordinates.put(mapIndex, (Object)coordinates);
    }

    static int getCoordinates(int mapIndex, int position) {
        return ((int[])coordinates.get(mapIndex))[position];
    }
}

