/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.items;

import joshie.harvest.api.core.ITiered;
import joshie.harvest.core.helpers.CropHelper;
import joshie.harvest.core.helpers.PlayerHelper;
import joshie.harvest.core.helpers.generic.DirectionHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.network.PacketWateringCan;
import joshie.harvest.items.ItemBaseTool;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemWateringCan
extends ItemBaseTool
implements IFluidContainerItem {
    @Override
    public int getFront(ItemStack stack) {
        ITiered.ToolTier tier = this.getTier(stack);
        switch (tier) {
            case BASIC: 
            case COPPER: {
                return 0;
            }
            case SILVER: {
                return 1;
            }
            case GOLD: {
                return 2;
            }
            case MYSTRIL: {
                return 4;
            }
            case CURSED: 
            case BLESSED: {
                return 6;
            }
            case MYTHIC: {
                return 12;
            }
        }
        return 0;
    }

    @Override
    public int getSides(ItemStack stack) {
        ITiered.ToolTier tier = this.getTier(stack);
        switch (tier) {
            case BASIC: {
                return 0;
            }
            case COPPER: 
            case SILVER: 
            case GOLD: {
                return 1;
            }
            case MYSTRIL: {
                return 2;
            }
            case CURSED: 
            case BLESSED: {
                return 6;
            }
            case MYTHIC: {
                return 10;
            }
        }
        return 0;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o()) {
            byte water = stack.func_77978_p().func_74771_c("Water");
            return (double)(water / 128) * 100.0;
        }
        return 0.0;
    }

    public FluidStack getFluid(ItemStack container) {
        return container.func_77942_o() ? new FluidStack(FluidRegistry.WATER, (int)container.func_77978_p().func_74771_c("Water")) : null;
    }

    public int getCapacity(ItemStack container) {
        return container.func_77942_o() ? (int)container.func_77978_p().func_74771_c("Water") : 0;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != FluidRegistry.WATER) {
            return 0;
        }
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        byte current_capacity = container.func_77978_p().func_74771_c("Water");
        int max_fill_capacity = Math.max(0, 127 - current_capacity);
        int amount_filled = 0;
        amount_filled = resource.amount >= max_fill_capacity ? max_fill_capacity : resource.amount;
        int new_amount = current_capacity + amount_filled;
        if (doFill) {
            container.func_77978_p().func_74774_a("Water", (byte)new_amount);
        }
        return amount_filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (maxDrain == 1 && container.func_77942_o()) {
            byte water = container.func_77978_p().func_74771_c("Water");
            if (water >= 1) {
                if (doDrain) {
                    container.func_77978_p().func_74774_a("Water", (byte)(water - 1));
                }
                return new FluidStack(FluidRegistry.WATER, 1);
            }
            return null;
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        this.attemptToFill(world, player, stack);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        this.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
        PacketHandler.sendToServer(new PacketWateringCan(stack, world, pos));
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult hydrate(EntityPlayer player, ItemStack stack, World world, BlockPos pos) {
        if (CropHelper.hydrate(world, pos)) {
            this.displayParticle(world, pos, EnumParticleTypes.WATER_SPLASH, Blocks.field_150355_j.func_176223_P());
            this.playSound(world, pos, SoundEvents.field_187549_bG, SoundCategory.NEUTRAL);
            PlayerHelper.performTask(player, stack, this.getExhaustionRate(stack));
            if (!player.field_71075_bZ.field_75098_d) {
                this.drain(stack, 1, true);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private boolean attemptToFill(World world, EntityPlayer player, ItemStack stack) {
        IBlockState state;
        RayTraceResult rayTraceResult = this.func_77621_a(world, player, true);
        if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(rayTraceResult.func_178782_a())).func_185904_a() == Material.field_151586_h) {
            return this.fill(stack, new FluidStack(FluidRegistry.WATER, 128), true) > 0;
        }
        return false;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.attemptToFill(world, player, stack)) {
            return EnumActionResult.PASS;
        }
        EnumFacing front = DirectionHelper.getFacingFromEntity((EntityLivingBase)player);
        Block initial = world.func_180495_p(pos).func_177230_c();
        if (!(initial instanceof BlockFarmland) && !(initial instanceof IPlantable)) {
            return EnumActionResult.FAIL;
        }
        EnumActionResult watered = EnumActionResult.FAIL;
        for (int y2 = pos.func_177956_o() - 1; y2 <= pos.func_177956_o(); ++y2) {
            for (int x2 = this.getXMinus(stack, front, pos.func_177958_n()); x2 <= this.getXPlus(stack, front, pos.func_177958_n()); ++x2) {
                for (int z2 = this.getZMinus(stack, front, pos.func_177952_p()); z2 <= this.getZPlus(stack, front, pos.func_177952_p()); ++z2) {
                    if (this.getCapacity(stack) <= 0) continue;
                    Block block = world.func_180495_p(new BlockPos(x2, y2, z2)).func_177230_c();
                    if (block instanceof IPlantable) {
                        watered = this.hydrate(player, stack, world, new BlockPos(x2, y2 - 1, z2));
                        continue;
                    }
                    if (!(block instanceof BlockFarmland)) continue;
                    watered = this.hydrate(player, stack, world, new BlockPos(x2, y2, z2));
                }
            }
        }
        return watered;
    }
}

