/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.items;

import java.util.List;
import joshie.harvest.api.core.ICreativeSorted;
import joshie.harvest.api.core.IShippable;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.api.core.ISizedProvider;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.helpers.SizeableHelper;
import joshie.harvest.core.lib.CreativeSort;
import joshie.harvest.core.lib.SizeableMeta;
import joshie.harvest.core.util.Translate;
import joshie.harvest.core.util.base.ItemHFBaseMeta;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class ItemSized
extends ItemHFBaseMeta
implements IShippable,
ICreativeSorted,
ISizedProvider {
    private final SizeableMeta meta;

    public ItemSized(SizeableMeta meta) {
        this.meta = meta;
    }

    public ISizeable getSizeable(ItemStack stack) {
        return this.meta;
    }

    @Override
    public int getMetaCount() {
        return 4;
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return CreativeSort.SIZEABLE + stack.func_77952_i() + this.meta.ordinal() * 3;
    }

    @Override
    public long getSellValue(ItemStack stack) {
        return this.meta.getSellValue(SizeableHelper.getSize((int)stack.func_77952_i()));
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.getName(stack) + "_" + this.meta.getSize(stack).toString().toLowerCase();
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        ISizeable.Size sizeof = SizeableHelper.getSize((int)stack.func_77952_i());
        String text = Translate.translate("sizeable.format");
        String size = Translate.translate("sizeable." + sizeof.name().toLowerCase());
        String name = Translate.translate("sizeable." + this.meta.name().toLowerCase());
        text = StringUtils.replace((String)text, (String)"%S", (String)size);
        text = StringUtils.replace((String)text, (String)"%P", (String)name);
        return text;
    }

    @Override
    public String getName(ItemStack stack) {
        return this.meta.name().toLowerCase();
    }

    @Override
    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{HFTab.FARMING};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
    }
}

