/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.items;

import java.util.HashSet;
import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.cooking.IAltItem;
import joshie.harvest.api.cooking.IMeal;
import joshie.harvest.api.cooking.IMealProvider;
import joshie.harvest.api.cooking.IMealRecipe;
import joshie.harvest.api.core.ICreativeSorted;
import joshie.harvest.cooking.Utensil;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.config.General;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.util.Translate;
import joshie.harvest.core.util.base.ItemHFBaseMeta;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMeal
extends ItemHFBaseMeta
implements IMealProvider,
ICreativeSorted,
IAltItem {
    public ItemMeal() {
        super(HFTab.COOKING);
    }

    public static String getMeal(ItemStack stack) {
        return stack.func_77978_p().func_74779_i("FoodName");
    }

    @Override
    public int getMetaCount() {
        return 1;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o()) {
            return Translate.translate("meal." + ItemMeal.getMeal(stack));
        }
        int meta = Math.min(Utensil.values().length - 1, stack.func_77952_i());
        return TextFormatting.DARK_GRAY + Translate.translate("meal.burnt." + Utensil.values()[meta].name().replace("_", ".").toLowerCase());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean debug) {
        if (General.DEBUG_MODE && debug && stack.func_77942_o()) {
            list.add(Translate.translate("meal.level") + " : " + stack.func_77978_p().func_74762_e("FoodLevel"));
            list.add(Translate.translate("meal.sat") + " : " + stack.func_77978_p().func_74760_g("FoodSaturation"));
            list.add(Translate.translate("meal.stamina") + " : " + stack.func_77978_p().func_74762_e("FoodStamina"));
            list.add(Translate.translate("meal.fatigue") + " : " + stack.func_77978_p().func_74762_e("FoodFatigue"));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (stack.func_77942_o() && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            int level = stack.func_77978_p().func_74762_e("FoodLevel");
            float sat = stack.func_77978_p().func_74760_g("FoodSaturation");
            int stamina = stack.func_77978_p().func_74762_e("FoodStamina");
            int fatigue = stack.func_77978_p().func_74762_e("FoodFatigue");
            HFTrackers.getPlayerTracker((EntityPlayer)player).getStats().affectStats(stamina, fatigue);
            player.func_71024_bL().func_75122_a(level, sat);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            return stack;
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("EatTime");
        }
        return super.func_77626_a(stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74767_n("IsDrink") ? EnumAction.DRINK : EnumAction.EAT;
        }
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_71043_e(false)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public static ItemStack cook(ItemStack stack, IMeal meal) {
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("FoodName", meal.getUnlocalizedName());
        stack.func_77978_p().func_74768_a("FoodLevel", meal.getHunger());
        stack.func_77978_p().func_74776_a("FoodSaturation", meal.getSaturation());
        stack.func_77978_p().func_74768_a("FoodStamina", meal.getStamina());
        stack.func_77978_p().func_74768_a("FoodFatigue", meal.getFatigue());
        stack.func_77978_p().func_74757_a("IsDrink", meal.isDrink());
        stack.func_77978_p().func_74768_a("EatTime", meal.getEatTime());
        return stack;
    }

    @Override
    public String getMealName(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return "burnt";
        }
        return stack.func_77978_p().func_74779_i("FoodName");
    }

    @Override
    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{HFTab.COOKING};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creative, List<ItemStack> list) {
        HashSet<IMeal> added = new HashSet<IMeal>();
        for (IMealRecipe recipe : HFApi.COOKING.getRecipes()) {
            IMeal best = recipe.getBestMeal();
            if (!added.add(best)) continue;
            list.add(ItemMeal.cook(new ItemStack(item), best));
        }
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 100;
    }

    @Override
    public ItemStack getAlternativeWhenCooking(ItemStack stack) {
        IMealRecipe recipe = HFApi.COOKING.getRecipe(ItemMeal.getMeal(stack));
        if (recipe != null) {
            return recipe.getMeal().getAlternativeItem();
        }
        return null;
    }
}

