/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.items;

import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.core.ICreativeSorted;
import joshie.harvest.api.core.ISeasonData;
import joshie.harvest.api.crops.ICrop;
import joshie.harvest.blocks.HFBlocks;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.config.Crops;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.SeedHelper;
import joshie.harvest.core.helpers.generic.RegistryHelper;
import joshie.harvest.core.lib.CreativeSort;
import joshie.harvest.crops.Crop;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(modid="AgriCraft", iface="com.InfinityRaider.AgriCraft.farming.ICropOverridingSeed")
public class ItemHFSeeds
extends ItemSeeds
implements ICreativeSorted {
    public ItemHFSeeds() {
        super((Block)HFBlocks.CROPS, (Block)HFBlocks.FARMLAND);
        this.func_77637_a(HFTab.FARMING);
        this.func_77627_a(true);
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return CreativeSort.SEEDS;
    }

    public Item func_77655_b(String name) {
        super.func_77655_b(name);
        RegistryHelper.registerItem((Item)this, name);
        return this;
    }

    public int getMetaCount() {
        return Crop.CROPS.size();
    }

    public String func_77653_i(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return "Corrupted Seeds, Yo!";
        }
        ICrop crop = SeedHelper.getCropFromSeed(stack);
        return crop == null ? "Bloody Useless Seeds" : crop.getSeedsName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean debug) {
        if (!stack.func_77942_o()) {
            return;
        }
        ICrop crop = SeedHelper.getCropFromSeed(stack);
        if (crop != null) {
            for (Season season : crop.getSeasons()) {
                ISeasonData data = HFApi.CALENDAR.getDataForSeason(season);
                list.add(data.getTextColor() + data.getLocalized());
            }
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing != EnumFacing.UP || !stack.func_77942_o()) {
            return EnumActionResult.FAIL;
        }
        ICrop crop = SeedHelper.getCropFromSeed(stack);
        if (crop != null) {
            int planted = 0;
            if (player.func_70093_af()) {
                planted = this.plantSeedAt(player, stack, world, pos, facing, crop, planted);
            } else {
                block0: for (int x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; ++x) {
                    for (int z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; ++z) {
                        if (crop.growsToSide() == null || x != pos.func_177958_n() || z != pos.func_177952_p()) {
                            planted = this.plantSeedAt(player, stack, world, new BlockPos(x, pos.func_177956_o(), z), facing, crop, planted);
                        }
                        if (planted >= 0 || !Crops.ALWAYS_GROW) continue;
                        planted = 2;
                        break block0;
                    }
                }
            }
            if (planted > 0) {
                --stack.field_77994_a;
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.FAIL;
    }

    private int plantSeedAt(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing facing, ICrop crop, int planted) {
        if (player.func_175151_a(pos, facing, stack) && player.func_175151_a(pos.func_177984_a(), facing, stack)) {
            IBlockState soil = world.func_180495_p(pos.func_177977_b());
            if (crop.getSoilHandler().canSustainPlant(soil, (IBlockAccess)world, pos.func_177984_a(), (IPlantable)HFBlocks.CROPS) && world.func_175623_d(pos.func_177984_a())) {
                HFTrackers.getCropTracker().plantCrop(player, world, pos.func_177984_a(), crop, 1);
                if (!world.field_72995_K) {
                    world.func_175656_a(pos.func_177984_a(), HFBlocks.CROPS.func_176223_P());
                }
                if (Crops.ALWAYS_GROW && ++planted >= 2) {
                    return -1;
                }
            }
        }
        return planted;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (ICrop crop : HFApi.CROPS.getCrops()) {
            list.add(SeedHelper.getSeedsFromCrop(crop));
        }
    }
}

