/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.items;

import java.util.HashMap;
import java.util.List;
import joshie.harvest.api.animals.IAnimalData;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.animals.IMilkable;
import joshie.harvest.api.core.ICreativeSorted;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.util.Translate;
import joshie.harvest.core.util.base.ItemHFBaseMeta;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGeneral
extends ItemHFBaseMeta
implements ICreativeSorted {
    public static final int BLUE_FEATHER = 0;
    public static final int MILKER = 1;
    public static final int BRUSH = 2;
    public static final int MEDICINE = 3;
    public static final int CHICKEN_FEED = 4;
    public static final int JUNK_ORE = 5;
    public static final int COPPER_ORE = 6;
    public static final int SILVER_ORE = 7;
    public static final int GOLD_ORE = 8;
    public static final int MYSTRIL_ORE = 9;
    public static final int MYTHIC_STONE = 10;
    public static final int FLOUR = 11;
    public static final int OIL = 12;
    public static final int RICEBALL = 13;
    public static final int SALT = 14;
    public static final int MIRACLE = 15;
    public static final int CHOCOLATE = 16;
    public static final int BUTTER = 17;
    public static final int EGG_SCRAMBLED = 18;
    public static final int COOKIES = 19;
    public static final int SASHIMI = 20;
    public static final int KETCHUP = 21;
    private HashMap<EntityPlayer, IMilkable> milkables = new HashMap();

    @Override
    public int getMetaCount() {
        return 22;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.getName(stack);
    }

    @Override
    public String getName(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 0: {
                return "feather_blue";
            }
            case 1: {
                return "milker";
            }
            case 2: {
                return "brush";
            }
            case 3: {
                return "medicine";
            }
            case 4: {
                return "feed";
            }
            case 5: {
                return "ore_junk";
            }
            case 6: {
                return "ore_copper";
            }
            case 7: {
                return "ore_silver";
            }
            case 8: {
                return "ore_gold";
            }
            case 9: {
                return "ore_mystril";
            }
            case 10: {
                return "stone_mythic";
            }
            case 11: {
                return "flour";
            }
            case 12: {
                return "oil";
            }
            case 13: {
                return "riceball";
            }
            case 14: {
                return "salt";
            }
            case 15: {
                return "miracle_potion";
            }
            case 16: {
                return "chocolate";
            }
            case 17: {
                return "butter";
            }
            case 18: {
                return "egg_scrambled";
            }
            case 19: {
                return "cookies";
            }
            case 20: {
                return "sashimi";
            }
            case 21: {
                return "ketchup";
            }
        }
        return "invalid";
    }

    @Override
    public boolean isValidTab(CreativeTabs tab, int meta) {
        switch (meta) {
            case 0: {
                return tab == HFTab.TOWN;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                return tab == HFTab.FARMING;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return tab == HFTab.MINING;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                return tab == HFTab.COOKING;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean setFull3D(int meta) {
        return meta == 2 || meta == 1;
    }

    public int func_77626_a(ItemStack stack) {
        return stack.func_77952_i() == 1 ? 32 : 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return stack.func_77952_i() == 1 ? EnumAction.BOW : EnumAction.NONE;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        EntityPlayer player;
        IMilkable milkable;
        if (entityLiving instanceof EntityPlayer && stack.func_77952_i() == 1 && (milkable = this.milkables.get(player = (EntityPlayer)entityLiving)) != null) {
            milkable.milk(player);
        }
        return stack;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase living, EnumHand hand) {
        if (living instanceof IAnimalTracked) {
            IAnimalTracked tracked = (IAnimalTracked)living;
            IAnimalData data = tracked.getData();
            int metadata = stack.func_77952_i();
            EntityAnimal animal = (EntityAnimal)living;
            if (metadata == 2 && !(living instanceof EntityChicken)) {
                if (!player.field_70170_p.field_72995_K) {
                    data.clean(player);
                } else {
                    int j = 0;
                    while ((double)j < 30.0) {
                        double d7 = animal.field_70163_u - 0.5 + (double)animal.field_70170_p.field_73012_v.nextFloat();
                        double d8 = animal.field_70165_t - 0.5 + (double)animal.field_70170_p.field_73012_v.nextFloat();
                        double d9 = animal.field_70161_v - 0.5 + (double)animal.field_70170_p.field_73012_v.nextFloat();
                        animal.field_70170_p.func_175688_a(EnumParticleTypes.TOWN_AURA, d8, 1.0 + d7 - 0.125, d9, 0.0, 0.0, 0.0, new int[0]);
                        ++j;
                    }
                }
                return true;
            }
            if (metadata == 3) {
                if (!player.field_70170_p.field_72995_K && data.heal(player)) {
                    --stack.field_77994_a;
                }
                return true;
            }
            if (metadata == 15 && !(living instanceof EntityChicken)) {
                if (!living.field_70170_p.field_72995_K && data.impregnate(player)) {
                    --stack.field_77994_a;
                }
                return true;
            }
            if (metadata == 1 && living instanceof IMilkable && ((IMilkable)living).canMilk()) {
                this.milkables.put(player, (IMilkable)living);
                player.func_184598_c(hand);
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSortValue(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            return 1;
        }
        if (stack.func_77952_i() >= 5 && stack.func_77952_i() <= 10) {
            return 10 + stack.func_77952_i();
        }
        return 102;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 0: 
            case 15: {
                return TextFormatting.AQUA + super.func_77653_i(stack);
            }
            case 10: {
                return TextFormatting.GREEN + super.func_77653_i(stack);
            }
        }
        return TextFormatting.WHITE + super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        if (stack.func_77952_i() == 10) {
            list.add(Translate.translate("tooltip.mythic_stone"));
        }
    }
}

