/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.items;

import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.buildings.IBuilding;
import joshie.harvest.api.core.ICreativeSorted;
import joshie.harvest.buildings.BuildingRegistry;
import joshie.harvest.buildings.loader.HFBuildings;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.helpers.UUIDHelper;
import joshie.harvest.core.util.base.ItemHFBaseMeta;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBuilding
extends ItemHFBaseMeta
implements ICreativeSorted {
    public ItemBuilding() {
        super(HFTab.TOWN);
    }

    public ItemStack getItemStack(IBuilding building) {
        ItemStack stack = new ItemStack((Item)this);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("Building", building.getResource().toString());
        return stack;
    }

    @Override
    public int getMetaCount() {
        return BuildingRegistry.buildings.size();
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.getName(stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBuilding group = this.getBuildingFromStack(stack);
        if (group != null) {
            return group.getProvider().generate(UUIDHelper.getPlayerUUID(player), world, pos);
        }
        return EnumActionResult.PASS;
    }

    public IBuilding getBuildingFromStack(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return HFBuildings.null_building;
        }
        IBuilding building = HFApi.BUILDINGS.getBuildingFromName(new ResourceLocation(stack.func_77978_p().func_74779_i("Building")));
        return building == null ? HFBuildings.null_building : building;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return "[SPAWN] " + this.getBuildingFromStack(stack).getLocalisedName();
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 200;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (tab == HFTab.TOWN) {
            for (IBuilding building : BuildingRegistry.buildings.values()) {
                if (building == null) continue;
                list.add(this.getItemStack(building));
            }
        }
    }
}

