/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.items;

import java.util.List;
import joshie.harvest.api.core.ICreativeSorted;
import joshie.harvest.api.core.ILevelable;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.core.lib.CreativeSort;
import joshie.harvest.core.util.Translate;
import joshie.harvest.items.ItemBaseSingle;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemBaseTool
extends ItemBaseSingle
implements ILevelable,
ITiered,
ICreativeSorted {
    public ItemBaseTool() {
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return CreativeSort.TOOLS + this.getTier(stack).ordinal();
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "_" + this.getTier(stack).name().toLowerCase();
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return Translate.translate(super.func_77658_a().replace("item.", "") + "." + this.getTier(stack).name().toLowerCase());
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @Override
    public int getLevel(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return (int)stack.func_77978_p().func_74769_h("Level");
    }

    @Override
    public ITiered.ToolTier getTier(ItemStack stack) {
        int safe = Math.min(Math.max(0, stack.func_77952_i()), ITiered.ToolTier.values().length - 1);
        return ITiered.ToolTier.values()[safe];
    }

    public int getFront(ItemStack stack) {
        return 0;
    }

    public int getSides(ItemStack stack) {
        return 0;
    }

    public double getExhaustionRate(ItemStack stack) {
        ITiered.ToolTier tier = this.getTier(stack);
        switch (tier) {
            case BASIC: {
                return 3.0;
            }
            case COPPER: {
                return 2.5;
            }
            case SILVER: 
            case GOLD: {
                return 2.0;
            }
            case MYSTRIL: {
                return 1.5;
            }
            case CURSED: {
                return 10.0;
            }
            case BLESSED: {
                return 1.0;
            }
            case MYTHIC: {
                return 0.5;
            }
        }
        return 0.0;
    }

    public double getLevelIncrease(ItemStack stack) {
        ITiered.ToolTier tier = this.getTier(stack);
        switch (tier) {
            case BASIC: {
                return 0.39215682745098;
            }
            case COPPER: {
                return 0.196078431372549;
            }
            case SILVER: 
            case GOLD: {
                return 0.130718954248366;
            }
            case MYSTRIL: {
                return 0.0980392156862745;
            }
            case CURSED: 
            case BLESSED: {
                return 0.0784313725490196;
            }
            case MYTHIC: {
                return 0.0392156862745098;
            }
        }
        return 0.0;
    }

    protected int getXMinus(ItemStack stack, EnumFacing facing, int x) {
        if (facing == EnumFacing.NORTH) {
            return x - this.getSides(stack);
        }
        if (facing == EnumFacing.SOUTH) {
            return x - this.getSides(stack);
        }
        if (facing == EnumFacing.EAST) {
            return x - this.getFront(stack);
        }
        return x;
    }

    protected int getXPlus(ItemStack stack, EnumFacing facing, int x) {
        if (facing == EnumFacing.NORTH) {
            return x + this.getSides(stack);
        }
        if (facing == EnumFacing.SOUTH) {
            return x + this.getSides(stack);
        }
        if (facing == EnumFacing.WEST) {
            return x + this.getFront(stack);
        }
        return x;
    }

    protected int getZMinus(ItemStack stack, EnumFacing facing, int z) {
        if (facing == EnumFacing.SOUTH) {
            return z - this.getFront(stack);
        }
        if (facing == EnumFacing.WEST) {
            return z - this.getSides(stack);
        }
        if (facing == EnumFacing.EAST) {
            return z - this.getSides(stack);
        }
        return z;
    }

    protected int getZPlus(ItemStack stack, EnumFacing facing, int z) {
        if (facing == EnumFacing.NORTH) {
            return z + this.getFront(stack);
        }
        if (facing == EnumFacing.WEST) {
            return z + this.getSides(stack);
        }
        if (facing == EnumFacing.EAST) {
            return z + this.getSides(stack);
        }
        return z;
    }

    protected void displayParticle(World world, BlockPos pos, EnumParticleTypes particle, IBlockState state) {
        int j = 0;
        while ((double)j < 60.0) {
            double d8 = (float)pos.func_177958_n() + world.field_73012_v.nextFloat();
            double d9 = (float)pos.func_177952_p() + world.field_73012_v.nextFloat();
            world.func_175688_a(particle, d8, (double)pos.func_177956_o() + 1.0 - 0.125, d9, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
            ++j;
        }
    }

    protected void playSound(World world, BlockPos pos, SoundEvent sound, SoundCategory category) {
        world.func_184133_a(null, pos, sound, category, world.field_73012_v.nextFloat() * 0.25f + 0.75f, world.field_73012_v.nextFloat() * 1.0f + 0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < ITiered.ToolTier.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

