/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.items;

import java.util.EnumMap;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.crops.ICrop;
import joshie.harvest.core.config.General;
import joshie.harvest.core.helpers.SeedHelper;
import joshie.harvest.core.lib.SizeableMeta;
import joshie.harvest.items.ItemAnimal;
import joshie.harvest.items.ItemAxe;
import joshie.harvest.items.ItemBuilding;
import joshie.harvest.items.ItemCheat;
import joshie.harvest.items.ItemCrop;
import joshie.harvest.items.ItemGeneral;
import joshie.harvest.items.ItemHFSeeds;
import joshie.harvest.items.ItemHammer;
import joshie.harvest.items.ItemHoe;
import joshie.harvest.items.ItemMeal;
import joshie.harvest.items.ItemNPCSpawner;
import joshie.harvest.items.ItemSickle;
import joshie.harvest.items.ItemTreat;
import joshie.harvest.items.ItemWateringCan;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class HFItems {
    private static final EnumMap<SizeableMeta, Item> SIZED = new EnumMap(SizeableMeta.class);
    public static final Item EGG = HFItems.getSizedItem(SizeableMeta.EGG);
    public static final Item MILK = HFItems.getSizedItem(SizeableMeta.MILK);
    public static final Item MAYONNAISE = HFItems.getSizedItem(SizeableMeta.MAYONNAISE);
    public static final Item WOOL = HFItems.getSizedItem(SizeableMeta.WOOL);
    public static final Item HOE = new ItemHoe().func_77655_b("hoe");
    public static final Item SICKLE = new ItemSickle().func_77655_b("sickle");
    public static final Item WATERING_CAN = new ItemWateringCan().func_77655_b("wateringcan");
    public static final Item HAMMER = new ItemHammer().func_77655_b("hammer");
    public static final Item AXE = new ItemAxe().func_77655_b("axe");
    public static final Item GENERAL = new ItemGeneral().func_77655_b("general.item");
    public static final Item MEAL = new ItemMeal().func_77655_b("meal");
    public static final Item ANIMAL = new ItemAnimal().func_77655_b("animal");
    public static final ItemTreat TREATS = (ItemTreat)new ItemTreat().func_77655_b("treat");
    public static final Item SEEDS = new ItemHFSeeds().func_77655_b("crops.seeds");
    public static final Item STRUCTURES = new ItemBuilding().func_77655_b("structures");
    public static final Item SPAWNER_NPC = new ItemNPCSpawner().func_77655_b("spawner.npc");

    public static void preInit() {
        for (ICrop crop : HFApi.CROPS.getCrops()) {
            if (!crop.hasItemAssigned()) {
                crop.setItem(new ItemStack(new ItemCrop(crop).func_77655_b("crop." + crop.getResource().func_110623_a()), 1, 0));
            }
            ItemStack clone = crop.getCropStack().func_77946_l();
            clone.func_77964_b(Short.MAX_VALUE);
            String name = "crop" + WordUtils.capitalizeFully((String)crop.getResource().func_110623_a().replace("_", ""));
            if (HFItems.isInDictionary(name, clone)) continue;
            OreDictionary.registerOre((String)name, (ItemStack)clone);
        }
        if (General.DEBUG_MODE) {
            new ItemCheat().func_77655_b("cheat");
        }
    }

    private static boolean isInDictionary(String name, ItemStack stack) {
        for (ItemStack check : OreDictionary.getOres((String)name)) {
            if (check.func_77973_b() != stack.func_77973_b() || check.func_77952_i() != Short.MAX_VALUE && check.func_77952_i() != stack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        colors.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (!stack.func_77942_o()) {
                    return -1;
                }
                ICrop crop = SeedHelper.getCropFromSeed(stack);
                return crop != null ? crop.getColor() : -1;
            }
        }, new Item[]{SEEDS});
    }

    public static Item getSizedItem(SizeableMeta size) {
        if (SIZED.containsKey(size)) {
            return SIZED.get(size);
        }
        Item item = size.getOrCreateStack();
        SIZED.put(size, item);
        return item;
    }
}

