/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.gathering.block;

import java.util.Locale;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.gathering.ISmashable;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFSmashable;
import joshie.harvest.core.base.item.ItemToolSmashing;
import joshie.harvest.tools.HFTools;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWood
extends BlockHFSmashable<BlockWood, Wood> {
    private static final AxisAlignedBB BRANCH_SMALL_AABB = new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.15, 0.85);
    private static final AxisAlignedBB BRANCH_MEDIUM_AABB = new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.25, 0.85);
    private static final AxisAlignedBB BRANCH_LARGE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9, 1.0);
    private static final AxisAlignedBB STUMP_SMALL_AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.25, 0.8);
    private static final AxisAlignedBB STUMP_MEDIUM_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.35, 0.9);
    private static final AxisAlignedBB STUMP_LARGE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockWood() {
        super(Material.field_151575_d, Wood.class, HFTab.GATHERING);
        this.setHardness(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Override
    public String getToolType(Wood type) {
        return "axe";
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((Wood)((Object)this.getEnumFromState(state))) {
            case BRANCH_SMALL: {
                return BRANCH_SMALL_AABB;
            }
            case BRANCH_MEDIUM: {
                return BRANCH_MEDIUM_AABB;
            }
            case BRANCH_LARGE: {
                return BRANCH_LARGE_AABB;
            }
            case STUMP_SMALL: {
                return STUMP_SMALL_AABB;
            }
            case STUMP_MEDIUM: {
                return STUMP_MEDIUM_AABB;
            }
            case STUMP_LARGE: {
                return STUMP_LARGE_AABB;
            }
        }
        return STUMP_LARGE_AABB;
    }

    @Override
    public ISmashable.ToolType getToolType() {
        return ISmashable.ToolType.AXE;
    }

    @Override
    public ItemToolSmashing getTool() {
        return HFTools.AXE;
    }

    @Override
    public long getSellValue(ItemStack stack) {
        return 1L;
    }

    @Override
    public ItemStack getDrop(EntityPlayer player, World world, BlockPos pos, IBlockState state, float luck) {
        Wood type = (Wood)((Object)this.getEnumFromState(state));
        switch (type) {
            case BRANCH_SMALL: {
                return new ItemStack(Blocks.field_150364_r, 1);
            }
            case BRANCH_MEDIUM: {
                return new ItemStack(Blocks.field_150364_r, 2);
            }
            case BRANCH_LARGE: {
                return new ItemStack(Blocks.field_150364_r, 6);
            }
            case STUMP_SMALL: {
                return new ItemStack(Blocks.field_150364_r, 3);
            }
            case STUMP_MEDIUM: {
                return new ItemStack(Blocks.field_150364_r, 4);
            }
            case STUMP_LARGE: {
                return new ItemStack(Blocks.field_150364_r, 12);
            }
        }
        return null;
    }

    @Override
    public ITiered.ToolTier getRequiredTier(IBlockState state) {
        switch ((Wood)((Object)this.getEnumFromState(state))) {
            case BRANCH_SMALL: {
                return ITiered.ToolTier.BASIC;
            }
            case BRANCH_MEDIUM: {
                return ITiered.ToolTier.COPPER;
            }
            case BRANCH_LARGE: {
                return ITiered.ToolTier.GOLD;
            }
            case STUMP_SMALL: {
                return ITiered.ToolTier.SILVER;
            }
            case STUMP_MEDIUM: {
                return ITiered.ToolTier.GOLD;
            }
            case STUMP_LARGE: {
                return ITiered.ToolTier.MYSTRIL;
            }
        }
        return null;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.getToolLevel(this.getEnumFromState(state));
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return -49 + stack.func_77952_i();
    }

    public static enum Wood implements IStringSerializable
    {
        BRANCH_SMALL,
        BRANCH_MEDIUM,
        BRANCH_LARGE,
        STUMP_SMALL,
        STUMP_MEDIUM,
        STUMP_LARGE;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

