/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.gathering.block;

import java.util.Locale;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.gathering.ISmashable;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFSmashable;
import joshie.harvest.core.base.item.ItemToolSmashing;
import joshie.harvest.tools.HFTools;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRock
extends BlockHFSmashable<BlockRock, Rock> {
    private static final AxisAlignedBB STONE_SMALL_AABB = new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.15, 0.85);
    private static final AxisAlignedBB STONE_MEDIUM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
    private static final AxisAlignedBB STONE_LARGE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3, 1.0);
    private static final AxisAlignedBB BOULDER_SMALL_AABB = new AxisAlignedBB(0.225, 0.0, 0.225, 0.775, 0.25, 0.775);
    private static final AxisAlignedBB BOULDER_MEDIUM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.35, 1.0);
    private static final AxisAlignedBB BOULDER_LARGE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6, 1.0);

    public BlockRock() {
        super(Material.field_151576_e, Rock.class, HFTab.GATHERING);
        this.setHardness(1.5f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    public long getSellValue(ItemStack stack) {
        return 1L;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((Rock)((Object)this.getEnumFromState(state))) {
            case STONE_SMALL: {
                return STONE_SMALL_AABB;
            }
            case STONE_MEDIUM: {
                return STONE_MEDIUM_AABB;
            }
            case STONE_LARGE: {
                return STONE_LARGE_AABB;
            }
            case BOULDER_SMALL: {
                return BOULDER_SMALL_AABB;
            }
            case BOULDER_MEDIUM: {
                return BOULDER_MEDIUM_AABB;
            }
            case BOULDER_LARGE: {
                return BOULDER_LARGE_AABB;
            }
        }
        return BOULDER_LARGE_AABB;
    }

    @Override
    public ISmashable.ToolType getToolType() {
        return ISmashable.ToolType.HAMMER;
    }

    @Override
    public ItemToolSmashing getTool() {
        return HFTools.HAMMER;
    }

    @Override
    public ItemStack getDrop(EntityPlayer player, World world, BlockPos pos, IBlockState state, float luck) {
        switch ((Rock)((Object)this.getEnumFromState(state))) {
            case STONE_SMALL: {
                return new ItemStack(Blocks.field_150348_b, 1);
            }
            case STONE_MEDIUM: {
                return new ItemStack(Blocks.field_150348_b, 2);
            }
            case STONE_LARGE: {
                return new ItemStack(Blocks.field_150348_b, 4);
            }
            case BOULDER_SMALL: {
                return new ItemStack(Blocks.field_150348_b, 3);
            }
            case BOULDER_MEDIUM: {
                return new ItemStack(Blocks.field_150348_b, 6);
            }
            case BOULDER_LARGE: {
                return new ItemStack(Blocks.field_150348_b, 12);
            }
        }
        return null;
    }

    @Override
    public ITiered.ToolTier getRequiredTier(IBlockState state) {
        switch ((Rock)((Object)this.getEnumFromState(state))) {
            case STONE_SMALL: {
                return ITiered.ToolTier.BASIC;
            }
            case STONE_MEDIUM: {
                return ITiered.ToolTier.COPPER;
            }
            case STONE_LARGE: {
                return ITiered.ToolTier.SILVER;
            }
            case BOULDER_SMALL: {
                return ITiered.ToolTier.SILVER;
            }
            case BOULDER_MEDIUM: {
                return ITiered.ToolTier.GOLD;
            }
            case BOULDER_LARGE: {
                return ITiered.ToolTier.MYSTRIL;
            }
        }
        return null;
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.getToolLevel(this.getEnumFromState(state)) * 2;
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return -29 + stack.func_77952_i();
    }

    public static enum Rock implements IStringSerializable
    {
        STONE_SMALL,
        STONE_MEDIUM,
        STONE_LARGE,
        BOULDER_SMALL,
        BOULDER_MEDIUM,
        BOULDER_LARGE;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

