/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.gathering.block;

import java.util.Locale;
import javax.annotation.Nonnull;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFEnum;
import joshie.harvest.core.block.BlockFlower;
import joshie.harvest.core.util.interfaces.ISellable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNature
extends BlockHFEnum<BlockNature, NaturalBlock>
implements IPlantable {
    protected static final AxisAlignedBB GRASS_AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);

    public BlockNature() {
        super(Material.field_151585_k, NaturalBlock.class, HFTab.GATHERING);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public boolean func_176196_c(@Nonnull World world, @Nonnull BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos.func_177977_b(), soil);
    }

    private boolean canSustainBush(IBlockState state) {
        return state.func_185904_a() == Material.field_151578_c;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        super.func_189540_a(state, world, pos, neighborBlock);
        this.checkAndDropBlock(world, pos, state);
    }

    private void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState soil = world.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return this.canSustainBush(world.func_180495_p(pos.func_177977_b()));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return GRASS_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    @Override
    public int getEntityLifeSpan(ItemStack stack, World world) {
        return stack.func_77952_i() == BlockFlower.FlowerType.GODDESS.ordinal() ? 50 : 6000;
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return -99;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (int i = 0; i < ((NaturalBlock[])this.values).length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("harvestfestival", this.property.func_177701_a() + "_" + ((NaturalBlock)this.getEnumFromMeta(i)).func_176610_l()), "inventory"));
        }
    }

    public static enum NaturalBlock implements IStringSerializable,
    ISellable
    {
        MATSUTAKE(350L),
        BAMBOO(50L),
        MINT(20L),
        CHAMOMILE(30L),
        LAVENDAR(40L);

        private final long sell;

        private NaturalBlock(long sell) {
            this.sell = sell;
        }

        @Override
        public long getSellValue() {
            return this.sell;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

