/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.gathering;

import java.util.EnumMap;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.gathering.IGatheringRegistry;
import joshie.harvest.core.util.HFApiImplementation;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;

@HFApiImplementation
public class GatheringRegistry
implements IGatheringRegistry {
    public static final GatheringRegistry INSTANCE = new GatheringRegistry();
    private final EnumMap<Season, WeightedState> gatherings = new EnumMap(Season.class);

    private GatheringRegistry() {
    }

    @Override
    public void registerGathering(Season season, IBlockState state, double weight) {
        WeightedState weightedState = this.gatherings.get((Object)season);
        if (weightedState == null) {
            weightedState = new WeightedState();
            this.gatherings.put(season, weightedState);
        }
        weightedState.add(state, weight);
    }

    @Override
    public void registerGathering(IBlockState state, double weight) {
        for (Season season : Season.values()) {
            this.registerGathering(season, state, weight);
        }
    }

    @Override
    public IBlockState getRandomStateForSeason(World world, @Nullable Season season) {
        if (season == null) {
            return null;
        }
        return this.gatherings.get((Object)season).get(world);
    }

    private class WeightedState {
        private final NavigableMap<Double, IBlockState> map = new TreeMap<Double, IBlockState>();
        private double total = 0.0;

        private WeightedState() {
        }

        public void add(IBlockState state, double weight) {
            if (weight <= 0.0) {
                return;
            }
            this.total += weight;
            this.map.put(this.total, state);
        }

        public IBlockState get(World world) {
            return this.map.ceilingEntry(world.field_73012_v.nextDouble() * this.total).getValue();
        }
    }
}

