/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.gathering;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.gathering.GatheringLocation;
import joshie.harvest.town.TownBuilding;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GatheringData {
    private Set<GatheringLocation> locations = new HashSet<GatheringLocation>();

    public void newDay(World world, Collection<TownBuilding> buildings) {
        HashSet<GatheringLocation> previous = new HashSet<GatheringLocation>(this.locations);
        this.locations = new HashSet<GatheringLocation>();
        for (GatheringLocation location : previous) {
            if (world.func_175667_e(location.pos)) {
                IBlockState state = world.func_180495_p(location.pos);
                if (state.func_177230_c() != location.block || state.func_177230_c().func_176201_c(state) != location.meta || state.func_177230_c().func_176201_c(state) != location.meta) continue;
                world.func_175698_g(location.pos);
                continue;
            }
            this.locations.add(location);
        }
        Season season = HFApi.calendar.getDate(world).getSeason();
        for (TownBuilding building : buildings) {
            int placed = 0;
            for (int i = 0; i < 256 && placed < 10; ++i) {
                IBlockState random;
                BlockPos pos = building.pos.func_177982_a(32 - world.field_73012_v.nextInt(64), 8 - world.field_73012_v.nextInt(16), 32 - world.field_73012_v.nextInt(64));
                if (!world.func_175667_e(pos) || world.func_180495_p(pos).func_177230_c() != Blocks.field_150349_c || !world.func_175623_d(pos.func_177984_a()) || !world.func_175710_j(pos.func_177984_a()) || (random = HFApi.gathering.getRandomStateForSeason(world, season)) == null || !world.func_180501_a(pos.func_177984_a(), random, 2)) continue;
                this.locations.add(new GatheringLocation(random, pos.func_177984_a()));
                ++placed;
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("GatheringLocations", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            GatheringLocation location = new GatheringLocation();
            location.readFromNBT(tag);
            this.locations.add(location);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (GatheringLocation location : this.locations) {
            NBTTagCompound tag = new NBTTagCompound();
            location.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("GatheringLocations", (NBTBase)list);
    }
}

