/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.fishing.item;

import java.util.List;
import java.util.Locale;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.item.ItemHFFoodEnum;
import joshie.harvest.core.util.interfaces.ISellable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFish
extends ItemHFFoodEnum<ItemFish, Fish> {
    public static final String SIZE = "Size";
    public static final int SMALL_FISH = 1;
    public static final int MEDIUM_FISH = 2;
    public static final int LARGE_FISH = 3;
    public static final int GIANT_FISH = 4;

    public ItemFish() {
        super(HFTab.FISHING, Fish.class);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Fish fish = (Fish)this.getEnumFromStack(stack);
        double weight = stack.func_77942_o() ? stack.func_77978_p().func_74769_h(SIZE) : fish.getLengthFromSizeOfFish(1);
        tooltip.add("Length: " + weight + "cm");
    }

    public double getLengthFromSizeOfFish(ItemStack stack, int size) {
        return ((Fish)this.getEnumFromStack(stack)).getLengthFromSizeOfFish(size);
    }

    public int func_150905_g(ItemStack stack) {
        return ((Fish)this.getEnumFromStack(stack)).getFoodAmount();
    }

    public float func_150906_h(ItemStack stack) {
        return 0.6f;
    }

    protected void func_77849_c(ItemStack stack, World worldIn, EntityPlayer player) {
        if (((Fish)this.getEnumFromStack(stack)).isPoisonous()) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 1200, 3));
            player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 300, 2));
            player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 300, 1));
        }
        super.func_77849_c(stack, worldIn, player);
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 1000;
    }

    public static enum Fish implements IStringSerializable,
    ISellable
    {
        ANCHOVY(30L, 2.0, 40.0),
        ANGEL(230L, 5.0, 15.0),
        ANGLER(500L, 20.0, 100.0),
        BASS(105L, 35.0, 75.0),
        BLAASOP(365L, 34.0, 110.0),
        BOWFIN(130L, 50.0, 109.0),
        BUTTERFLY(200L, 12.0, 22.0),
        CARP(60L, 35.0, 105.0),
        CATFISH(120L, 100.0, 250.0),
        CHUB(40L, 40.0, 80.0),
        CLOWN(170L, 10.0, 18.0),
        COD(50L, 5.0, 200.0),
        DAMSEL(105L, 3.0, 5.0),
        ELECTRICRAY(230L, 80.0, 190.0),
        GOLD(35L, 5.0, 45.0),
        HERRING(85L, 14.0, 46.0),
        KOI(280L, 25.0, 90.0),
        LAMPREY(100L, 13.0, 100.0),
        LUNGFISH(200L, 70.0, 150.0),
        MANTARAY(400L, 400.0, 700.0),
        MINNOW(20L, 2.0, 13.0),
        PERCH(65L, 7.5, 30.0),
        PICKEREL(140L, 50.0, 76.0),
        PIKE(235L, 60.0, 130.0),
        PIRANHA(400L, 30.0, 50.0),
        PUFFER(300L, 2.5, 61.0),
        PUPFISH(115L, 5.0, 8.0),
        SALMON(80L, 60.0, 80.0),
        SARDINE(20L, 8.0, 30.0),
        SIAMESE(200L, 4.0, 7.0),
        STARGAZER(140L, 25.0, 40.0),
        STINGRAY(250L, 150.0, 200.0),
        TANG(230L, 20.0, 35.0),
        TETRA(185L, 1.5, 4.0),
        TROUT(80L, 25.0, 90.0),
        TUNA(160L, 40.0, 460.0),
        WALLEYE(110L, 25.0, 35.0);

        private final long sell;
        private final double small;
        private final double medium;
        private final double large;
        private final double giant;
        private final int amount;

        private Fish(long sell, double min, double max) {
            this.sell = sell;
            this.small = min;
            this.medium = min + (max - min) * 0.0;
            this.large = this.medium * 2.0;
            this.giant = max;
            this.amount = (int)Math.min(10.0, Math.max(1.0, min / 10.0));
        }

        public boolean isPoisonous() {
            return this == BLAASOP || this == LAMPREY || this == PUFFER || this == STARGAZER || this == STINGRAY;
        }

        public int getFoodAmount() {
            return this.amount;
        }

        public double getLengthFromSizeOfFish(int size) {
            if (size == 1) {
                return this.small;
            }
            if (size == 2) {
                return this.medium;
            }
            if (size == 3) {
                return this.large;
            }
            if (size == 4) {
                return this.giant;
            }
            return this.small;
        }

        public long getSellValue(double size) {
            if (size >= this.giant) {
                return (long)((double)this.sell * 1.75);
            }
            if (size >= this.large) {
                return (long)((double)this.sell * 1.5);
            }
            if (size >= this.medium) {
                return (long)((double)this.sell * 1.25);
            }
            return this.sell;
        }

        @Override
        public long getSellValue() {
            return this.sell;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

