/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops.tile;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.ticking.IDailyTickable;
import joshie.harvest.core.base.tile.TileDaily;
import joshie.harvest.core.helpers.MCServerHelper;
import joshie.harvest.crops.HFCrops;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileSprinkler
extends TileDaily
implements ITickable {
    private int tick;
    private final FluidTank tank = new FluidTank(1000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid() == FluidRegistry.WATER;
        }
    };

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.tick % 15 == 0 && this.tank.getFluidAmount() > 1) {
                int setting = 2 - Minecraft.func_71410_x().field_71474_y.field_74362_aa;
                for (int i = 0; i < setting * 32; ++i) {
                    double one = this.field_145850_b.field_73012_v.nextDouble() - 0.5;
                    double two = this.field_145850_b.field_73012_v.nextDouble() - 0.5;
                    this.field_145850_b.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.7, (double)this.func_174877_v().func_177952_p() + 0.5, one, 0.0, two, new int[0]);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.7, (double)this.func_174877_v().func_177952_p() + 0.5, one - 0.05, 0.0, two - 0.05, new int[0]);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.7, (double)this.func_174877_v().func_177952_p() + 0.5, one - 0.05, 0.0, two + 0.05, new int[0]);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.7, (double)this.func_174877_v().func_177952_p() + 0.5, one + 0.05, 0.0, two - 0.05, new int[0]);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.7, (double)this.func_174877_v().func_177952_p() + 0.5, one + 0.05, 0.0, two + 0.05, new int[0]);
                }
            }
            ++this.tick;
        }
    }

    public void hydrateSoil() {
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = 0; y >= -1; --y) {
                    BlockPos position = new BlockPos(this.func_174877_v().func_177958_n() + x, this.func_174877_v().func_177956_o() + y, this.func_174877_v().func_177952_p() + z);
                    if (position.equals((Object)this.func_174877_v())) continue;
                    HFApi.crops.hydrateSoil(null, this.func_145831_w(), position);
                }
            }
        }
    }

    @Override
    public void newDay(IDailyTickable.Phase phase) {
        if (phase == IDailyTickable.Phase.PRE && this.tank.getFluidAmount() > 1) {
            this.tank.drainInternal(HFCrops.SPRINKLER_DRAIN_RATE, true);
            this.hydrateSoil();
            if (this.tank.getFluidAmount() <= 1) {
                MCServerHelper.markTileForUpdate(this);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        return super.func_189515_b(tag);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }
}

