/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops.item;

import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.util.ICreativeSorted;
import joshie.harvest.core.util.Text;
import joshie.harvest.crops.HFCrops;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHFSeeds
extends ItemSeeds
implements ICreativeSorted {
    public ItemHFSeeds() {
        super((Block)HFCrops.CROPS, Blocks.field_150458_ak);
        this.func_77637_a(HFTab.FARMING);
        this.func_77627_a(true);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 9;
    }

    public String func_77653_i(ItemStack stack) {
        Crop crop = this.getCropFromStack(stack);
        return crop == null ? Text.translate("crop.seeds.useless") : crop.getSeedsName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean debug) {
        Crop crop = this.getCropFromStack(stack);
        if (crop != null) {
            if (crop.requiresSickle()) {
                list.add("" + TextFormatting.AQUA + TextFormatting.ITALIC + Text.translate("crop.sickle"));
            }
            crop.getGrowthHandler().addInformation(list, crop, debug);
            list.add(crop.getStages() + " " + Text.translate("crop.seeds.days"));
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        Crop crop = this.getCropFromStack(stack);
        if (crop != null) {
            int planted = 0;
            if (player.func_70093_af()) {
                planted = this.plantSeedAt(player, stack, world, pos, facing, crop, planted);
            } else {
                for (int x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; ++x) {
                    for (int z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; ++z) {
                        planted = this.plantSeedAt(player, stack, world, new BlockPos(x, pos.func_177956_o(), z), facing, crop, planted);
                    }
                }
            }
            if (planted > 0) {
                --stack.field_77994_a;
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.FAIL;
    }

    private int plantSeedAt(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing facing, Crop crop, int planted) {
        if (player.func_175151_a(pos, facing, stack) && player.func_175151_a(pos.func_177984_a(), facing, stack) && crop.getGrowthHandler().canSustainCrop((IBlockAccess)world, pos, world.func_180495_p(pos), crop) && world.func_175623_d(pos.func_177984_a())) {
            if (!world.field_72995_K) {
                world.func_180501_a(pos.func_177984_a(), HFCrops.CROPS.func_176223_P(), 2);
            }
            HFApi.crops.plantCrop(player, world, pos.func_177984_a(), crop, 1);
            ++planted;
        }
        return planted;
    }

    public ItemStack getStackFromCrop(Crop crop) {
        return new ItemStack((Item)this, 1, Crop.REGISTRY.getValues().indexOf(crop));
    }

    public Crop getCropFromStack(ItemStack stack) {
        int id = Math.max(0, Math.min(Crop.REGISTRY.getValues().size() - 1, stack.func_77952_i()));
        return (Crop)Crop.REGISTRY.getValues().get(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (Crop crop : Crop.REGISTRY.getValues()) {
            if (crop == Crop.NULL_CROP) continue;
            list.add(this.getStackFromCrop(crop));
        }
    }

    public ItemHFSeeds register(String name) {
        this.func_77655_b(name.replace("_", "."));
        this.setRegistryName(new ResourceLocation("harvestfestival", name));
        GameRegistry.register((IForgeRegistryEntry)this);
        return this;
    }
}

