/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops.handlers.growth;

import joshie.harvest.api.trees.GrowthHandlerTree;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.buildings.ResourceLoader;
import joshie.harvest.core.util.HFTemplate;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.crops.block.BlockFruit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class GrowthHandlerHFTree
extends GrowthHandlerTree {
    private final HFTemplate template;
    private final BlockFruit.Fruit fruit;

    public GrowthHandlerHFTree(BlockFruit.Fruit fruit) {
        this.fruit = fruit;
        this.template = (HFTemplate)HFBuildings.getGson().fromJson(ResourceLoader.getJSONResource(new ResourceLocation("harvestfestival", fruit.func_176610_l()), "trees"), HFTemplate.class);
    }

    @Override
    protected void growTree(World world, BlockPos pos) {
        Rotation rotation = Rotation.values()[world.field_73012_v.nextInt(Rotation.values().length)];
        this.template.placeBlocks(world, this.getAdjustedPositionBasedOnRotation(pos, rotation), rotation);
    }

    protected abstract BlockPos getAdjustedPositionBasedOnRotation(BlockPos var1, Rotation var2);

    protected abstract boolean isLeaves(IBlockState var1);

    @Override
    protected void growFruit(World world, BlockPos thePos) {
        int attempts = 0;
        while (true) {
            IBlockState above;
            BlockPos pos;
            if (world.func_175623_d(pos = thePos.func_177982_a(world.field_73012_v.nextInt(16) - 8, world.field_73012_v.nextInt(8), world.field_73012_v.nextInt(16) - 8)) && this.isLeaves(above = world.func_180495_p(pos.func_177984_a()))) {
                world.func_175656_a(pos, HFCrops.FRUITS.getStateFromEnum(this.fruit));
                break;
            }
            if (attempts == 1000) break;
            ++attempts;
        }
    }
}

