/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops.handlers;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.crops.WateringHandler;
import joshie.harvest.api.ticking.IDailyTickableBlock;
import joshie.harvest.core.util.annotations.HFEvents;
import joshie.harvest.crops.CropHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WateringTickHandler {

    public static class Ticker
    implements IDailyTickableBlock {
        public static final Ticker INSTANCE = new Ticker();

        @Override
        public boolean newDay(World world, BlockPos pos, IBlockState state) {
            WateringHandler handler = CropHelper.getWateringHandler((World)world, (BlockPos)pos, (IBlockState)state);
            if (handler != null) {
                if (CropHelper.isRainingAt(world, pos.func_177981_b(2))) {
                    if (!handler.isWet(world, pos, state)) {
                        handler.hydrate(world, pos, state);
                    }
                } else {
                    handler.dehydrate(world, pos, state);
                }
                return true;
            }
            return false;
        }
    }

    @HFEvents
    public static class Load {
        @SubscribeEvent
        public void onChunkData(ChunkDataEvent.Load event) {
            ExtendedBlockStorage[] array = event.getChunk().func_76587_i();
            Chunk chunk = event.getChunk();
            World world = chunk.func_177412_p();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 256; ++y) {
                        IBlockState state;
                        BlockPos pos;
                        WateringHandler handler;
                        ExtendedBlockStorage extendedblockstorage = array[y >> 4];
                        if (extendedblockstorage == Chunk.field_186036_a || (handler = CropHelper.getWateringHandler((World)world, (BlockPos)(pos = new BlockPos(chunk.field_76635_g * 16 + x, y, chunk.field_76647_h * 16 + z)), (IBlockState)(state = extendedblockstorage.func_177485_a(x, y & 0xF, z)))) == null) continue;
                        HFApi.tickable.addTickable(world, pos, Ticker.INSTANCE);
                        if (handler.isWet(world, pos, state) || !world.func_72896_J()) continue;
                        handler.hydrate(world, pos, state);
                    }
                }
            }
        }
    }
}

