/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops.block;

import java.util.Locale;
import javax.annotation.Nullable;
import joshie.harvest.core.base.block.BlockHFEnum;
import joshie.harvest.crops.tile.TileSprinkler;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockSprinkler
extends BlockHFEnum<BlockSprinkler, Sprinkler> {
    private static final AxisAlignedBB WOOD_AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.7, 0.8);

    public BlockSprinkler() {
        super(Material.field_151575_d, Sprinkler.class);
        this.func_149672_a(SoundType.field_185849_b);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return WOOD_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (heldItem != null && (tile = worldIn.func_175625_s(pos)) instanceof TileSprinkler) {
            TileSprinkler sprinkler = (TileSprinkler)tile;
            ItemStack result = FluidUtil.tryEmptyContainer((ItemStack)heldItem, (IFluidHandler)sprinkler.getTank(), (int)1000, (EntityPlayer)player, (boolean)true);
            if (result != null) {
                if (result.field_77994_a > 0) {
                    player.func_184611_a(hand, result);
                }
                if (!worldIn.field_72995_K) {
                    sprinkler.hydrateSoil();
                }
                sprinkler.saveAndRefresh();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSprinkler();
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 10;
    }

    public static enum Sprinkler implements IStringSerializable
    {
        WOOD;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

