/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops.block;

import java.util.Locale;
import java.util.Random;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.AnimalFoodType;
import joshie.harvest.api.animals.IAnimalFeeder;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.api.crops.IBreakCrops;
import joshie.harvest.api.crops.IStateHandler;
import joshie.harvest.calendar.Calendar;
import joshie.harvest.core.base.block.BlockHFEnum;
import joshie.harvest.core.base.item.ItemBlockHF;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.MCServerHelper;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.crops.CropData;
import joshie.harvest.crops.CropHelper;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.crops.tile.TileCrop;
import joshie.harvest.crops.tile.TileWithered;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHFCrops
extends BlockHFEnum<BlockHFCrops, CropType>
implements IPlantable,
IGrowable,
IAnimalFeeder {
    public static final AxisAlignedBB CROP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockHFCrops() {
        super(Material.field_151585_k, CropType.class, null);
        this.setBlockUnbreakable();
        this.func_149672_a(SoundType.field_185849_b);
        if (!HFCrops.GROWS_DAILY) {
            this.func_149675_a(true);
        }
        this.func_149649_H();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        if (state.func_177227_a().contains(this.property)) {
            return ((CropType)((Object)state.func_177229_b((IProperty)this.property))).ordinal();
        }
        return 0;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!HFCrops.GROWS_DAILY && !world.field_72995_K) {
            CropType stage = (CropType)((Object)this.getEnumFromState(state));
            if (stage == CropType.WITHERED) {
                return;
            }
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(20) == 0) {
                this.func_176474_b(world, rand, pos, state);
            }
        }
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        CropType stage = (CropType)((Object)this.getEnumFromState(state));
        ItemStack held = player.func_184614_ca();
        if (held == null || !(held.func_77973_b() instanceof IBreakCrops)) {
            return stage.isWithered() ? 0.0f : 0.75f;
        }
        return ((IBreakCrops)held.func_77973_b()).getStrengthVSCrops(player, world, pos, state, held);
    }

    public static IStateHandler.PlantSection getSection(IBlockState state) {
        if (state.func_177230_c() != HFCrops.CROPS) {
            return null;
        }
        int stage = state.func_177230_c().func_176201_c(state);
        IStateHandler.PlantSection section = IStateHandler.PlantSection.BOTTOM;
        if (stage == CropType.WITHERED_DOUBLE.ordinal() || stage == CropType.FRESH_DOUBLE.ordinal()) {
            section = IStateHandler.PlantSection.TOP;
        }
        return section;
    }

    public static boolean isWithered(IBlockState state) {
        int stage = state.func_177230_c().func_176201_c(state);
        return stage == CropType.WITHERED.ordinal() || stage == CropType.WITHERED_DOUBLE.ordinal();
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean canStay(World world, BlockPos pos) {
        Crop crop;
        CropData data = CropHelper.getCropDataAt((IBlockAccess)world, pos);
        if (data != null && (crop = data.getCrop()).getGrowthHandler() != null) {
            IBlockState down = world.func_180495_p(pos.func_177977_b());
            return down.func_177230_c() == this || crop.getGrowthHandler().canSustainCrop((IBlockAccess)world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), crop);
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        CropType stage = (CropType)((Object)this.getEnumFromState(state));
        if (stage == CropType.WITHERED || stage == CropType.WITHERED_DOUBLE) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        IStateHandler.PlantSection section = BlockHFCrops.getSection(state);
        CropData data = CropHelper.getCropDataAt((IBlockAccess)world, pos);
        if (data == null || data.getCrop().requiresSickle() || data.getCrop().growsToSide() != null) {
            return false;
        }
        if (section == IStateHandler.PlantSection.BOTTOM) {
            return CropHelper.harvestCrop(player, world, pos);
        }
        return CropHelper.harvestCrop(player, world, pos.func_177977_b());
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        if (!world.field_72995_K && !this.canStay(world, pos)) {
            world.func_175698_g(pos);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        IBlockState stateUp;
        boolean isSickle;
        CropType stage = (CropType)((Object)this.getEnumFromState(state));
        if (stage == CropType.WITHERED || stage == CropType.WITHERED_DOUBLE) {
            return world.func_175698_g(pos);
        }
        IStateHandler.PlantSection section = BlockHFCrops.getSection(state);
        CropData data = CropHelper.getCropDataAt((IBlockAccess)world, pos);
        if (data == null) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        Crop crop = data.getCrop();
        int originalStage = data.getStage();
        boolean bl = isSickle = player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof IBreakCrops;
        if (isSickle || !crop.requiresSickle()) {
            if (section == IStateHandler.PlantSection.BOTTOM) {
                CropHelper.harvestCrop(player, world, pos);
            } else {
                CropHelper.harvestCrop(player, world, pos.func_177977_b());
            }
        }
        if (crop.isCurrentlyDouble(data.getStage()) && section == IStateHandler.PlantSection.BOTTOM && (stateUp = world.func_180495_p(pos.func_177984_a())).func_177230_c() == this) {
            CropHelper.onBottomBroken(pos.func_177984_a(), this.func_176221_a(stateUp, (IBlockAccess)world, pos.func_177984_a()));
        }
        if (isSickle && crop.getMinimumCut() != 0 && crop.requiresSickle() && originalStage >= crop.getMinimumCut()) {
            return data.markSafe(world, pos, section);
        }
        return world.func_175698_g(pos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        CropData data;
        CropType stage = (CropType)((Object)this.getEnumFromState(state));
        if (stage == CropType.FRESH || stage == CropType.WITHERED) {
            CropData data2 = CropHelper.getCropDataAt((IBlockAccess)world, pos);
            if (data2 == null || data2.isClearable()) {
                CropType above;
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && ((above = (CropType)((Object)this.getEnumFromState(world.func_180495_p(pos.func_177984_a())))) == CropType.FRESH_DOUBLE || above == CropType.WITHERED_DOUBLE)) {
                    world.func_175698_g(pos.func_177984_a());
                }
            } else {
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && !data2.getCrop().isCurrentlyDouble(data2.getStage())) {
                    data2.markSafe(world, pos.func_177984_a(), IStateHandler.PlantSection.TOP);
                }
                HFApi.crops.plantCrop(null, world, pos, data2.getCrop(), data2.getCrop().getRegrowStage());
            }
        } else if (!(stage != CropType.FRESH_DOUBLE && stage != CropType.WITHERED_DOUBLE || (data = CropHelper.getCropDataAt((IBlockAccess)world, pos.func_177977_b())) != null && !data.isClearable())) {
            world.func_175698_g(pos.func_177977_b());
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        CropType stage = (CropType)((Object)this.getEnumFromState(state));
        CropData data = CropHelper.getCropDataAt(world, pos);
        return data != null ? data.getCrop().getStateHandler().getBoundingBox(world, pos, stage.getSection(), data.getStage(), stage.isWithered()) : CROP_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.getEnumFromState(state) == CropType.WITHERED) {
            return new ItemStack((Block)Blocks.field_150330_I);
        }
        CropData data = CropHelper.getCropDataAt((IBlockAccess)world, pos);
        return data == null ? new ItemStack((Block)Blocks.field_150330_I) : HFCrops.SEEDS.getStackFromCrop(data.getCrop());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        CropType stage = (CropType)((Object)this.getEnumFromState(state));
        TileWithered crop = CropHelper.getTile(world, pos, stage.getSection());
        if (stage.getSection() == IStateHandler.PlantSection.TOP && crop == null) {
            IBlockState theState = CropHelper.getTempState(pos);
            return theState == null ? Blocks.field_150349_c.func_176223_P() : theState;
        }
        if (crop != null) {
            return crop.getData().getCrop().getStateHandler().getState(world, pos, stage.getSection(), crop.getData().getStage(), stage.isWithered());
        }
        return Blocks.field_150330_I.func_176223_P();
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (this.getEnumFromState(state) == CropType.WITHERED) {
            return false;
        }
        if (HFCrops.ENABLE_BONEMEAL) {
            if (HFCrops.SEASONAL_BONEMEAL) {
                CropData data = CropHelper.getCropDataAt((IBlockAccess)world, pos);
                if (data != null && data.getCrop().getGrowthHandler().canGrow(world, pos, data.getCrop())) {
                    return this.canGrow(world, pos, state);
                }
                return false;
            }
            return this.canGrow(world, pos, state);
        }
        return false;
    }

    private boolean canGrow(World world, BlockPos pos, IBlockState state) {
        TileWithered crop = CropHelper.getTile((IBlockAccess)world, pos, BlockHFCrops.getSection(state));
        if (crop != null) {
            return crop.getData().getStage() < crop.getData().getCrop().getStages();
        }
        return false;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        TileWithered crop = CropHelper.getTile((IBlockAccess)world, pos, BlockHFCrops.getSection(state));
        if (crop != null) {
            crop.getData().grow(world, pos);
            crop.saveAndRefresh();
            MCServerHelper.markTileForUpdate(crop);
        }
    }

    @Override
    public boolean feedAnimal(IAnimalTracked tracked, World world, BlockPos pos, IBlockState state) {
        int stage;
        CropData data;
        if (HFApi.animals.canAnimalEatFoodType(tracked, AnimalFoodType.GRASS) && (data = CropHelper.getCropDataAt((IBlockAccess)world, pos)) != null && data.getCrop() == HFCrops.GRASS && (stage = data.getStage()) > 5) {
            HFApi.crops.plantCrop(tracked.getData().getOwner(), world, pos, data.getCrop(), stage - 5);
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return ((CropType)((Object)this.getEnumFromState(state))).section == IStateHandler.PlantSection.BOTTOM;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return !((CropType)((Object)this.getEnumFromState(state))).isWithered() ? new TileCrop() : new TileWithered();
    }

    @Override
    public ItemBlockHF getItemBlock() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (int i = 0; i < ((CropType[])this.values).length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("harvestfestival", this.property.func_177701_a() + "_" + ((CropType)((Object)this.getEnumFromMeta(i))).func_176610_l()), "inventory"));
        }
    }

    @HFEvents
    public static class EventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
        public void onDirtTilled(UseHoeEvent event) {
            if (!event.getWorld().field_72995_K && !event.isCanceled()) {
                if (((Calendar)HFTrackers.getCalendar(event.getWorld())).getTodaysWeather().isRain() && CropHelper.isRainingAt(event.getWorld(), event.getPos().func_177981_b(2))) {
                    MinecraftForge.EVENT_BUS.register((Object)new RainingSoil(event.getWorld(), event.getPos()));
                }
                HFApi.tickable.addTickable(event.getWorld(), event.getPos(), HFApi.tickable.getTickableFromBlock(Blocks.field_150458_ak));
            }
        }
    }

    public static class RainingSoil {
        private int existence;
        private final World world;
        private final BlockPos pos;

        public RainingSoil(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
        }

        @SubscribeEvent
        public void onTick(TickEvent.WorldTickEvent event) {
            boolean remove;
            if (event.world != this.world) {
                return;
            }
            boolean bl = remove = this.existence >= 30;
            if (remove) {
                IBlockState state = this.world.func_180495_p(this.pos);
                if (state.func_177230_c() instanceof BlockFarmland) {
                    this.world.func_175656_a(this.pos, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)));
                }
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
            ++this.existence;
        }
    }

    public static enum CropType implements IStringSerializable
    {
        FRESH(IStateHandler.PlantSection.BOTTOM),
        WITHERED(IStateHandler.PlantSection.BOTTOM),
        FRESH_DOUBLE(IStateHandler.PlantSection.TOP),
        WITHERED_DOUBLE(IStateHandler.PlantSection.TOP);

        private final IStateHandler.PlantSection section;

        private CropType(IStateHandler.PlantSection section) {
            this.section = section;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        public boolean isWithered() {
            return this == WITHERED || this == WITHERED_DOUBLE;
        }

        public IStateHandler.PlantSection getSection() {
            return this.section;
        }
    }
}

