/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import joshie.harvest.api.crops.Crop;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class SetCropType
extends LootFunction {
    private static List<Crop> cropsList;
    private final String crop;

    public SetCropType(LootCondition[] conditionsIn, String crop) {
        super(conditionsIn);
        this.crop = crop;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (this.crop.equals("randomCrop")) {
            return this.random(true);
        }
        if (this.crop.equals("randomSeed")) {
            return this.random(false);
        }
        ResourceLocation resource = this.crop.contains(":") ? new ResourceLocation(this.crop) : new ResourceLocation("harvestfestival", this.crop);
        Crop theCrop = (Crop)Crop.REGISTRY.getValue(resource);
        stack.func_77964_b(Crop.REGISTRY.getValues().indexOf(theCrop));
        return stack;
    }

    public ItemStack random(boolean crop) {
        if (cropsList == null) {
            cropsList = new ArrayList<Crop>(Crop.REGISTRY.getValues());
            cropsList.remove(Crop.NULL_CROP);
        }
        Collections.shuffle(cropsList);
        return crop ? cropsList.get(0).getCropStack(1) : cropsList.get(0).getSeedStack(1);
    }

    public static class Serializer
    extends LootFunction.Serializer<SetCropType> {
        protected Serializer() {
            super(new ResourceLocation("hf_set_crop"), SetCropType.class);
        }

        public void serialize(JsonObject object, SetCropType functionClazz, JsonSerializationContext serializationContext) {
            object.addProperty("crop", functionClazz.crop);
        }

        public SetCropType deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new SetCropType(conditionsIn, object.get("crop").getAsString());
        }
    }
}

