/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops;

import java.util.Iterator;
import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.AnimalFoodType;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.api.crops.GrowthHandler;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.FMLDefinition;
import joshie.harvest.core.base.MeshIdentical;
import joshie.harvest.core.handlers.DisableHandler;
import joshie.harvest.core.helpers.ConfigHelper;
import joshie.harvest.core.helpers.RegistryHelper;
import joshie.harvest.core.util.HFLoader;
import joshie.harvest.core.util.IFMLItem;
import joshie.harvest.crops.CropData;
import joshie.harvest.crops.CropHelper;
import joshie.harvest.crops.CropStateMapper;
import joshie.harvest.crops.SetCropType;
import joshie.harvest.crops.block.BlockHFCrops;
import joshie.harvest.crops.block.BlockSprinkler;
import joshie.harvest.crops.handlers.drop.DropHandlerGrass;
import joshie.harvest.crops.handlers.drop.DropHandlerMelon;
import joshie.harvest.crops.handlers.drop.DropHandlerNetherWart;
import joshie.harvest.crops.handlers.drop.DropHandlerPotato;
import joshie.harvest.crops.handlers.growth.GrowthHandlerNether;
import joshie.harvest.crops.handlers.state.StateHandlerBeetroot;
import joshie.harvest.crops.handlers.state.StateHandlerCabbage;
import joshie.harvest.crops.handlers.state.StateHandlerCorn;
import joshie.harvest.crops.handlers.state.StateHandlerCucumber;
import joshie.harvest.crops.handlers.state.StateHandlerEggplant;
import joshie.harvest.crops.handlers.state.StateHandlerGrass;
import joshie.harvest.crops.handlers.state.StateHandlerGreenPepper;
import joshie.harvest.crops.handlers.state.StateHandlerMelon;
import joshie.harvest.crops.handlers.state.StateHandlerNetherWart;
import joshie.harvest.crops.handlers.state.StateHandlerOnion;
import joshie.harvest.crops.handlers.state.StateHandlerPineapple;
import joshie.harvest.crops.handlers.state.StateHandlerPumpkin;
import joshie.harvest.crops.handlers.state.StateHandlerSeedFood;
import joshie.harvest.crops.handlers.state.StateHandlerSpinach;
import joshie.harvest.crops.handlers.state.StateHandlerStrawberry;
import joshie.harvest.crops.handlers.state.StateHandlerSweetPotato;
import joshie.harvest.crops.handlers.state.StateHandlerTomato;
import joshie.harvest.crops.handlers.state.StateHandlerTurnip;
import joshie.harvest.crops.handlers.state.StateHandlerWheat;
import joshie.harvest.crops.item.ItemCrop;
import joshie.harvest.crops.item.ItemHFSeeds;
import joshie.harvest.crops.tile.TileCrop;
import joshie.harvest.crops.tile.TileSprinkler;
import joshie.harvest.crops.tile.TileWithered;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

@HFLoader(priority=8)
public class HFCrops {
    public static final BlockHFCrops CROPS = (BlockHFCrops)new BlockHFCrops().register("crops_block");
    public static final BlockSprinkler SPRINKLER = (BlockSprinkler)((Object)new BlockSprinkler().register("sprinkler"));
    public static final GrowthHandler SOUL_SAND = new GrowthHandlerNether();
    public static final ItemHFSeeds SEEDS = new ItemHFSeeds().register("crops_seeds");
    public static final ItemCrop CROP = (ItemCrop)new ItemCrop().register("crops");
    public static final Crop TURNIP = HFCrops.registerCrop("turnip", 120L, 60L, 5, 0, 0, 0xFFFFFF, Season.SPRING).setFoodStats(1, 0.4f).setStateHandler(new StateHandlerTurnip());
    public static final Crop POTATO = HFCrops.registerCrop("potato", 150L, 80L, 8, 0, 0, 12487979, Season.SPRING).setItem(new ItemStack(Items.field_151174_bG)).setDropHandler(new DropHandlerPotato()).setStateHandler(new StateHandlerSeedFood(Blocks.field_150469_bN));
    public static final Crop CUCUMBER = HFCrops.registerCrop("cucumber", 200L, 60L, 10, 5, 0, 3584787, Season.SPRING).setFoodStats(2, 0.25f).setAnimalFoodType(AnimalFoodType.FRUIT).setStateHandler(new StateHandlerCucumber());
    public static final Crop STRAWBERRY = HFCrops.registerCrop("strawberry", 150L, 30L, 9, 7, 1, 16743402, Season.SPRING).setFoodStats(3, 0.8f).setAnimalFoodType(AnimalFoodType.FRUIT).setStateHandler(new StateHandlerStrawberry());
    public static final Crop CABBAGE = HFCrops.registerCrop("cabbage", 500L, 250L, 15, 0, 3, 9436992, Season.SPRING).setFoodStats(1, 0.5f).setStateHandler(new StateHandlerCabbage());
    public static final Crop ONION = HFCrops.registerCrop("onion", 150L, 80L, 8, 0, 0, 14467847, Season.SUMMER).setFoodStats(1, 0.4f).setStateHandler(new StateHandlerOnion());
    public static final Crop TOMATO = HFCrops.registerCrop("tomato", 200L, 60L, 10, 7, 0, 15075360, Season.SUMMER).setFoodStats(3, 0.5f).setAnimalFoodType(AnimalFoodType.FRUIT).setStateHandler(new StateHandlerTomato());
    public static final Crop CORN = HFCrops.registerCrop("corn", 300L, 100L, 15, 12, 0, 13942085, Season.SUMMER).setFoodStats(2, 0.3f).setStateHandler(new StateHandlerCorn());
    public static final Crop PUMPKIN = HFCrops.registerCrop("pumpkin", 500L, 250L, 15, 0, 1, 14719545, Season.SUMMER).setIngredient(new Ingredient("pumpkin", 2, 0.3f)).setItem(new ItemStack(Blocks.field_150423_aK)).setGrowsToSide(Blocks.field_150423_aK).setStateHandler(new StateHandlerPumpkin());
    public static final Crop PINEAPPLE = HFCrops.registerCrop("pineapple", 1000L, 500L, 21, 16, 3, 14143232, Season.SUMMER).setFoodStats(2, 1.34f).setAnimalFoodType(AnimalFoodType.FRUIT).setStateHandler(new StateHandlerPineapple());
    public static final Crop WATERMELON = HFCrops.registerCrop("watermelon", 250L, 25L, 11, 0, 1, 13183806, Season.SUMMER).setItem(new ItemStack(Items.field_151127_ba)).setAnimalFoodType(AnimalFoodType.FRUIT).setDropHandler(new DropHandlerMelon()).setGrowsToSide(Blocks.field_150440_ba).setStateHandler(new StateHandlerMelon());
    public static final Crop EGGPLANT = HFCrops.registerCrop("eggplant", 120L, 80L, 10, 7, 0, 10640580, Season.AUTUMN).setFoodStats(3, 1.1f).setStateHandler(new StateHandlerEggplant());
    public static final Crop SPINACH = HFCrops.registerCrop("spinach", 200L, 80L, 6, 0, 1, 9481749, Season.AUTUMN).setFoodStats(2, 1.0f).setStateHandler(new StateHandlerSpinach());
    public static final Crop CARROT = HFCrops.registerCrop("carrot", 300L, 120L, 8, 0, 0, 16297011, Season.AUTUMN).setItem(new ItemStack(Items.field_151172_bF)).setStateHandler(new StateHandlerSeedFood(Blocks.field_150459_bM));
    public static final Crop SWEET_POTATO = HFCrops.registerCrop("sweet_potato", 300L, 60L, 6, 4, 0, 14166700, Season.AUTUMN).setFoodStats(2, 0.35f).setStateHandler(new StateHandlerSweetPotato());
    public static final Crop GREEN_PEPPER = HFCrops.registerCrop("green_pepper", 150L, 40L, 8, 2, 3, 5689875, Season.AUTUMN).setFoodStats(2, 0.5f).setStateHandler(new StateHandlerGreenPepper());
    public static final Crop BEETROOT = HFCrops.registerCrop("beetroot", 250L, 75L, 8, 0, 0, 0x690000, Season.AUTUMN).setItem(new ItemStack(Items.field_185164_cV)).setStateHandler(new StateHandlerBeetroot());
    public static final Crop GRASS = HFCrops.registerCrop("grass", 500L, 1L, 11, 1, 0, 8046936, Season.SPRING, Season.SUMMER, Season.AUTUMN).setWitheredColor(8016432).setAnimalFoodType(AnimalFoodType.GRASS).setDropHandler(new DropHandlerGrass()).setBecomesDouble(6).setHasAlternativeName().setRequiresSickle(6).setNoWaterRequirements().setStateHandler(new StateHandlerGrass());
    public static final Crop WHEAT = HFCrops.registerCrop("wheat", 150L, 100L, 28, 0, 0, 15386389, Season.SPRING, Season.SUMMER, Season.AUTUMN).setIngredient(new Ingredient("wheat", 1, 0.1f)).setItem(new ItemStack(Items.field_151015_O)).setAnimalFoodType(AnimalFoodType.GRASS).setRequiresSickle(0).setStateHandler(new StateHandlerWheat());
    public static final Crop NETHER_WART = HFCrops.registerCrop("nether_wart", 25000L, 10L, 4, 1, 1, 0x8B0000, new Season[0]).setItem(new ItemStack(Items.field_151075_bm)).setStateHandler(new StateHandlerNetherWart()).setPlantType(EnumPlantType.Nether).setNoWaterRequirements().setGrowthHandler(SOUL_SAND).setDropHandler(new DropHandlerNetherWart());
    public static final Crop TUTORIAL = HFCrops.registerCrop("tutorial_turnip", 0L, 1L, 3, 0, 0, 11313762, Season.SPRING, Season.SUMMER, Season.AUTUMN, Season.WINTER).setFoodStats(1, 0.1f);
    private static List<List<ItemStack>> idToStack = (List)ReflectionHelper.getPrivateValue(OreDictionary.class, null, (String[])new String[]{"idToStack"});
    public static boolean SEASONAL_BONEMEAL;
    public static boolean ENABLE_BONEMEAL;
    public static boolean GROWS_DAILY;
    public static boolean DISABLE_VANILLA_HOE;
    public static boolean DISABLE_VANILLA_SEEDS;
    public static boolean DISABLE_VANILLA_GROWTH;
    public static boolean DISABLE_VANILLA_DROPS;
    public static boolean DISABLE_VANILLA_WHEAT_SEEDS;
    public static boolean DISABLE_VANILLA_MOISTURE;
    public static int SPRINKLER_DRAIN_RATE;
    public static boolean VALIDATE_FARMLAND;
    private static boolean CROPS_DIE_CLIENT;
    private static boolean CROPS_DIE_SERVER;
    public static boolean CROPS_SHOULD_DIE;

    public static void preInit() {
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetCropType.Serializer());
        HFCrops.registerVanillaCrop(Blocks.field_150464_aj, Items.field_151015_O, WHEAT);
        HFCrops.registerVanillaCrop(Blocks.field_150459_bM, Items.field_151172_bF, CARROT);
        HFCrops.registerVanillaCrop(Blocks.field_150469_bN, Items.field_151174_bG, POTATO);
        HFCrops.registerVanillaCrop(Blocks.field_185773_cZ, Items.field_185164_cV, BEETROOT);
        HFCrops.registerVanillaCrop(Blocks.field_150394_bc, Items.field_151127_ba, WATERMELON);
        HFCrops.registerVanillaCrop(Blocks.field_150393_bb, Blocks.field_150423_aK, PUMPKIN);
        HFCrops.registerVanillaCrop(Blocks.field_150388_bm, Items.field_151075_bm, NETHER_WART);
        HFApi.shipping.registerSellable(new ItemStack(Items.field_151170_bI), 1L);
        RegistryHelper.registerTiles(TileWithered.class, TileCrop.class, TileSprinkler.class);
        if (DISABLE_VANILLA_MOISTURE) {
            Blocks.field_150458_ak.func_149675_a(false);
        }
        if (DISABLE_VANILLA_WHEAT_SEEDS || DISABLE_VANILLA_SEEDS) {
            DisableHandler.BLACKLIST.register(Items.field_151081_bc);
            DisableHandler.BLACKLIST.register(Items.field_151080_bb);
            DisableHandler.BLACKLIST.register(Items.field_185163_cU);
            DisableHandler.BLACKLIST.register(Items.field_151014_N);
            DisableHandler.BLACKLIST.register(CARROT);
            DisableHandler.BLACKLIST.register(POTATO);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        ModelLoader.setCustomMeshDefinition((Item)SEEDS, (ItemMeshDefinition)new MeshIdentical((Item)SEEDS));
        ModelLoader.setCustomStateMapper((Block)CROPS, (IStateMapper)new CropStateMapper());
        ModelLoader.setCustomMeshDefinition((Item)CROP, (ItemMeshDefinition)new FMLDefinition<Crop>((IFMLItem)CROP, "crops", Crop.REGISTRY){

            @Override
            public boolean shouldSkip(Crop crop) {
                return super.shouldSkip(crop) || crop.getCropStack(1).func_77973_b() != CROP || crop.skipLoadingRender();
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            Crop crop = SEEDS.getCropFromStack(stack);
            return crop != null ? crop.getColor() : -1;
        }, new Item[]{SEEDS});
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        IBlockColor coloring = (state, world, pos, tintIndex) -> {
            IBlockState actual;
            if (world != null && pos != null && (actual = world.func_180495_p(pos)).func_177230_c() == CROPS) {
                if (BlockHFCrops.isWithered(actual)) {
                    CropData data = CropHelper.getCropDataAt(world, pos);
                    return data != null ? data.getCrop().getWitheredColor() : 10898943;
                }
                CropData data = CropHelper.getCropDataAt(world, pos);
                if (data != null && (data.getCrop() == PUMPKIN || data.getCrop() == WATERMELON)) {
                    int range = data.getCrop().getStages() - 1;
                    int i = range == 0 ? 0 : (data.getStage() - 1) * 7 / range;
                    int j = i * 32;
                    int k = 255 - i * 8;
                    int l = i * 4;
                    return j << 16 | k << 8 | l;
                }
            }
            return -1;
        };
        colors.func_186722_a(coloring, new Block[]{CROPS});
        for (Crop crop : Crop.REGISTRY) {
            if (crop == Crop.NULL_CROP || !crop.skipLoadingRender()) continue;
            colors.func_186722_a(coloring, new Block[]{((IBlockState)crop.getStateHandler().getValidStates().get(0)).func_177230_c()});
        }
        FMLDefinition.getDefinition("crops").registerEverything();
    }

    public static void remap() {
        for (int i = 0; i < idToStack.size(); ++i) {
            Iterator<ItemStack> it = idToStack.get(i).iterator();
            while (it.hasNext()) {
                if (it.next().func_77973_b() != CROP) continue;
                it.remove();
            }
        }
        OreDictionary.rebakeMap();
        for (Crop crop : Crop.REGISTRY.getValues()) {
            if (crop == Crop.NULL_CROP) continue;
            ItemStack clone = crop.getCropStack(1);
            String name = "crop" + WordUtils.capitalizeFully((String)crop.getRegistryName().func_110623_a(), (char[])new char[]{'_'}).replace("_", "");
            if (HFCrops.isInDictionary(name, clone)) continue;
            OreDictionary.registerOre((String)name, (ItemStack)clone);
        }
    }

    private static void registerVanillaCrop(Block cropBlock, Item item, Crop crop) {
        HFApi.crops.registerCropProvider(new ItemStack(item), crop);
        crop.setSkipRender();
        item.func_77637_a((CreativeTabs)HFTab.FARMING);
        if (DISABLE_VANILLA_GROWTH || DISABLE_VANILLA_DROPS) {
            DisableHandler.CROPS.add(cropBlock);
        }
        if (DISABLE_VANILLA_GROWTH) {
            cropBlock.func_149675_a(false);
        }
    }

    private static void registerVanillaCrop(Block cropBlock, Block block, Crop crop) {
        HFApi.crops.registerCropProvider(new ItemStack(block), crop);
        crop.setSkipRender();
        block.func_149647_a((CreativeTabs)HFTab.FARMING);
        if (DISABLE_VANILLA_GROWTH || DISABLE_VANILLA_DROPS) {
            DisableHandler.CROPS.add(cropBlock);
        }
        if (DISABLE_VANILLA_GROWTH) {
            cropBlock.func_149675_a(false);
        }
    }

    private static Crop registerCrop(String name, long cost, long sell, int stages, int regrow, int year, int color, Season ... seasons) {
        return new Crop(new ResourceLocation("harvestfestival", name), cost, sell, stages, color, seasons).setRegrowStage(regrow).setYearUnlocked(year);
    }

    private static boolean isInDictionary(String name, ItemStack stack) {
        for (ItemStack check : OreDictionary.getOres((String)name)) {
            if (check.func_77973_b() != stack.func_77973_b() || check.func_77952_i() != Short.MAX_VALUE && check.func_77952_i() != stack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static void configure() {
        GROWS_DAILY = ConfigHelper.getBoolean("Crops grow daily", true, "This setting when set to true, will make crops grow based on day by day instead of based on random ticks");
        ENABLE_BONEMEAL = ConfigHelper.getBoolean("Enable bonemeal", false, "Enabling this will allow you to use bonemeal on plants to grow them.");
        SEASONAL_BONEMEAL = ConfigHelper.getBoolean("Seasonal bonemeal", true, "If you have bonemeal enabled, with this setting active, bonemeal will only work when the crop is in season");
        DISABLE_VANILLA_SEEDS = ConfigHelper.getBoolean("Disable vanilla seeds", true, "If this is true, vanilla seeds will not plant their crops");
        DISABLE_VANILLA_GROWTH = ConfigHelper.getBoolean("Disable vanilla growth", true, "If this is true, vanilla crops will not grow");
        DISABLE_VANILLA_DROPS = ConfigHelper.getBoolean("Disable vanilla drops", true, "If this is true, vanilla crops will not drop their items");
        DISABLE_VANILLA_WHEAT_SEEDS = ConfigHelper.getBoolean("Disable seed drops from grass", true, "If this is true, grass will not drop wheat seeds");
        DISABLE_VANILLA_HOE = ConfigHelper.getBoolean("Disable vanilla hoes", false, "If this is true, vanilla hoes will not till dirt");
        DISABLE_VANILLA_MOISTURE = ConfigHelper.getBoolean("Disable vanilla moisture", true, "If this is set to true then farmland will not automatically become wet, and must be watered, it will also not automatically revert to dirt. (Basically disables random ticks for farmland)");
        SPRINKLER_DRAIN_RATE = ConfigHelper.getInteger("Sprinkler's daily consumption", 250, "This number NEEDs to be a factor of 1000, Otherwise you'll have trouble refilling the sprinkler manually. Acceptable values are: 1, 2, 4, 5, 8, 10, 20, 25, 40, 50, 100, 125, 200, 250, 500, 1000");
        VALIDATE_FARMLAND = ConfigHelper.getBoolean("Check for farmland on chunk load", true, "Disable this if you think it will help...");
        CROPS_DIE_CLIENT = ConfigHelper.getBoolean("Integrated Server > Crops die when not having been watered", true);
        CROPS_DIE_SERVER = ConfigHelper.getBoolean("Dedicated Server > Crops die when not having been watered", false);
    }

    public static void onServerStarting() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        CROPS_SHOULD_DIE = server.func_71262_S() ? CROPS_DIE_SERVER : CROPS_DIE_CLIENT;
    }
}

