/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.WorldLocation;
import joshie.harvest.api.calendar.ICalendarDate;
import joshie.harvest.api.calendar.Weekday;
import joshie.harvest.api.crops.ICrop;
import joshie.harvest.api.crops.ICropData;
import joshie.harvest.blocks.BlockCrop;
import joshie.harvest.blocks.HFBlocks;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.CropHelper;
import joshie.harvest.core.helpers.generic.MCServerHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.network.PacketSyncCrop;
import joshie.harvest.crops.CropData;
import joshie.harvest.crops.CropTracker;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.IPlantable;

public class CropTrackerServer
extends CropTracker {
    private ICalendarDate lastRain;

    @Override
    public void newDay() {
        ArrayList<ICropData> toWither = new ArrayList<ICropData>();
        Weekday day = HFTrackers.getCalendar().getDate().getWeekday();
        Iterator iter = this.crops.entrySet().iterator();
        while (iter.hasNext()) {
            Block block;
            Map.Entry entry = iter.next();
            ICropData data = (ICropData)entry.getValue();
            WorldLocation location = (WorldLocation)entry.getKey();
            World world = MCServerHelper.getWorld(location.dimension);
            boolean removed = false;
            if (day == Weekday.FRIDAY && !((block = world.func_180495_p(location.position).func_177230_c()) instanceof IPlantable)) {
                iter.remove();
                removed = true;
            }
            if (!data.canGrow() || removed) continue;
            boolean alive = data.newDay();
            if (!alive) {
                toWither.add(data);
                continue;
            }
            PacketHandler.sendToEveryone(new PacketSyncCrop(location, data));
        }
        for (WorldLocation location : this.crops.keySet()) {
            World world = MCServerHelper.getWorld(location.dimension);
            CropHelper.dehydrate(world, location.position.func_177977_b(), world.func_180495_p(location.position.func_177977_b()));
        }
        Iterator wither = toWither.iterator();
        while (wither.hasNext()) {
            ICropData data = (ICropData)wither.next();
            wither.remove();
            this.setWithered(data);
        }
    }

    @Override
    public void doRain() {
        if (!HFTrackers.getCalendar().getDate().equals(this.lastRain)) {
            this.lastRain = HFApi.CALENDAR.cloneDate(HFTrackers.getCalendar().getDate());
            for (WorldLocation location : this.crops.keySet()) {
                World world = MCServerHelper.getWorld(location.dimension);
                IBlockState state = world.func_180495_p(location.position);
                this.hydrate(world, location.position, state);
                DimensionManager.getWorld((int)location.dimension).func_180501_a(location.position.func_177977_b(), state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            }
        }
    }

    @Override
    public void sendUpdateToClient(EntityPlayerMP player, World world, BlockPos pos) {
        WorldLocation key = this.getCropKey(world, pos);
        ICropData data = (ICropData)this.crops.get(key);
        if (data == null) {
            PacketHandler.sendToClient(new PacketSyncCrop(key), (EntityPlayer)player);
        } else {
            PacketHandler.sendToClient(new PacketSyncCrop(key, data), (EntityPlayer)player);
        }
    }

    @Override
    public void grow(World world, BlockPos pos) {
        ICropData data = this.getCropDataForLocation(world, pos);
        data.grow();
        PacketHandler.sendToEveryone(new PacketSyncCrop(data.getLocation(), data));
        HFTrackers.markDirty();
    }

    @Override
    public boolean plantCrop(EntityPlayer player, World world, BlockPos pos, ICrop crop, int stage) {
        ICropData data = this.getCropDataForLocation(world, pos);
        if (CropHelper.isHydrated(world, pos.func_177977_b())) {
            data.setHydrated();
        }
        data.setCrop(player, crop, stage);
        this.crops.put(data.getLocation(), data);
        PacketHandler.sendToEveryone(new PacketSyncCrop(data.getLocation(), data));
        HFTrackers.markDirty();
        return true;
    }

    @Override
    public ItemStack harvest(EntityPlayer player, World world, BlockPos pos) {
        ICropData data = this.getCropDataForLocation(world, pos);
        ItemStack harvest = data.harvest(player, true);
        if (harvest != null) {
            if (data.getCrop().getRegrowStage() <= 0) {
                this.removeCrop(world, pos);
                world.func_175698_g(pos);
            }
            if (player != null) {
                HFTrackers.getServerPlayerTracker((EntityPlayer)player).getTracking().onHarvested(data);
            }
            HFTrackers.markDirty();
            PacketHandler.sendToEveryone(new PacketSyncCrop(data.getLocation(), data));
            return harvest;
        }
        return null;
    }

    @Override
    public void hydrate(World world, BlockPos pos, IBlockState state) {
        this.getCropDataForLocation(world, pos).setHydrated();
        HFTrackers.markDirty();
    }

    @Override
    public void setWithered(ICropData data) {
        WorldLocation location = data.getLocation();
        if (data.getCrop().isDouble(data.getStage())) {
            MCServerHelper.getWorld(location.dimension).func_180501_a(location.position.func_177984_a(), HFBlocks.CROPS.getStateFromEnum(BlockCrop.Stage.WITHERED_DOUBLE), 2);
        }
        MCServerHelper.getWorld(location.dimension).func_180501_a(location.position, HFBlocks.CROPS.getStateFromEnum(BlockCrop.Stage.WITHERED_DOUBLE), 2);
        this.plantCrop(null, MCServerHelper.getWorld(location.dimension), location.position, data.getCrop(), data.getStage());
    }

    @Override
    public void removeCrop(World world, BlockPos pos) {
        super.removeCrop(world, pos);
        HFTrackers.markDirty();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList crops = nbt.func_150295_c("CropData", 10);
        for (int i = 0; i < crops.func_74745_c(); ++i) {
            NBTTagCompound tag = crops.func_150305_b(i);
            WorldLocation location = new WorldLocation();
            location.readFromNBT(tag);
            CropData data = new CropData(location);
            data.readFromNBT(tag);
            this.crops.put(location, data);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList crops = new NBTTagList();
        for (Map.Entry entry : this.crops.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            ((WorldLocation)entry.getKey()).writeToNBT(tag);
            ((ICropData)entry.getValue()).writeToNBT(tag);
            crops.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("CropData", (NBTBase)crops);
    }
}

