/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops;

import java.util.HashMap;
import joshie.harvest.api.WorldLocation;
import joshie.harvest.api.crops.ICrop;
import joshie.harvest.api.crops.ICropData;
import joshie.harvest.crops.CropData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CropTracker {
    protected HashMap<WorldLocation, ICropData> crops = new HashMap();

    protected WorldLocation getCropKey(World world, BlockPos pos) {
        return new WorldLocation(world.field_73011_w.getDimension(), pos);
    }

    protected WorldLocation getFarmlandKey(World world, BlockPos pos) {
        return new WorldLocation(world.field_73011_w.getDimension(), pos.func_177984_a());
    }

    public ICropData getCropDataForLocation(World world, BlockPos pos) {
        WorldLocation location = this.getCropKey(world, pos);
        ICropData data = this.crops.get(location);
        return data != null ? data : new CropData(location);
    }

    public boolean canBonemeal(World world, BlockPos pos) {
        ICropData data = this.getCropDataForLocation(world, pos);
        return data.getStage() < data.getCrop().getStages();
    }

    public boolean plantCrop(EntityPlayer player, World world, BlockPos pos, ICrop crop, int stage) {
        return true;
    }

    public ItemStack getHarvest(EntityPlayer player, World world, BlockPos pos) {
        ICropData data = this.getCropDataForLocation(world, pos);
        return data.harvest(player, false);
    }

    public ItemStack harvest(EntityPlayer player, World world, BlockPos pos) {
        ICropData data = this.getCropDataForLocation(world, pos);
        ItemStack harvest = data.harvest(player, true);
        if (harvest != null) {
            if (data.getCrop().getRegrowStage() < 0) {
                this.removeCrop(world, pos);
            }
            return harvest;
        }
        return null;
    }

    public void removeCrop(World world, BlockPos pos) {
        ICropData data = this.getCropDataForLocation(world, pos);
        this.crops.remove(data.getLocation());
    }

    public void hydrate(World world, BlockPos pos, IBlockState state) {
    }

    public void setWithered(ICropData data) {
    }

    public void grow(World world, BlockPos pos) {
    }

    public void newDay() {
    }

    public void sendUpdateToClient(EntityPlayerMP player, World world, BlockPos pos) {
    }

    public void updateClient(boolean isRemoval, WorldLocation location, ICropData data) {
    }

    public void doRain() {
    }
}

