/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.api.crops.ICropProvider;
import joshie.harvest.api.crops.ICropRegistry;
import joshie.harvest.core.util.HFApiImplementation;
import joshie.harvest.core.util.holder.ItemStackHolder;
import joshie.harvest.crops.CropData;
import joshie.harvest.crops.CropHelper;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.crops.block.BlockHFCrops;
import joshie.harvest.crops.tile.TileWithered;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@HFApiImplementation
public class CropRegistry
implements ICropRegistry {
    public static final CropRegistry INSTANCE = new CropRegistry();
    private final HashMap<ItemStackHolder, Crop> providers = new HashMap();

    @Override
    public BlockStateContainer getStateContainer(PropertyInteger stages) {
        return new BlockStateContainer((Block)HFCrops.CROPS, new IProperty[]{HFCrops.CROPS.property, stages});
    }

    @Override
    public ItemStack getSeedStack(Crop crop, int amount) {
        ItemStack stack = HFCrops.SEEDS.getStackFromCrop(crop);
        stack.field_77994_a = amount;
        return stack;
    }

    @Override
    public ItemStack getCropStack(Crop crop, int amount) {
        ItemStack stack = HFCrops.CROP.getStackFromObject(crop);
        stack.field_77994_a = amount;
        return stack;
    }

    @Override
    public void registerCropProvider(ItemStack stack, Crop crop) {
        this.providers.put(ItemStackHolder.of(stack), crop);
    }

    public List<ItemStack> getStacksForCrop(Crop crop) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(crop.getCropStack(1));
        ItemStackHolder holder = ItemStackHolder.of(crop.getCropStack(1));
        for (Map.Entry<ItemStackHolder, Crop> entry : this.providers.entrySet()) {
            if (!entry.getValue().equals(crop)) continue;
            for (ItemStack stack : entry.getKey().getMatchingStacks()) {
                if (holder.matches(stack)) continue;
                list.add(stack);
            }
        }
        return list;
    }

    @Override
    public Crop getCropFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ICropProvider) {
            return ((ICropProvider)stack.func_77973_b()).getCrop(stack);
        }
        Crop crop = this.providers.get(ItemStackHolder.of(stack.func_77973_b(), Short.MAX_VALUE));
        return crop != null ? crop : this.providers.get(ItemStackHolder.of(stack));
    }

    @Override
    public Crop getCropAtLocation(World world, BlockPos pos) {
        CropData data = CropHelper.getCropDataAt((IBlockAccess)world, pos);
        return data != null ? data.getCrop() : null;
    }

    @Override
    public void plantCrop(@Nullable EntityPlayer player, World world, BlockPos pos, Crop theCrop, int stage) {
        TileWithered tile;
        world.func_175656_a(pos, HFCrops.CROPS.getStateFromEnum(BlockHFCrops.CropType.FRESH));
        if (theCrop.isCurrentlyDouble(stage)) {
            world.func_175656_a(pos.func_177984_a(), HFCrops.CROPS.getStateFromEnum(BlockHFCrops.CropType.FRESH_DOUBLE));
        }
        if ((tile = (TileWithered)world.func_175625_s(pos)) != null) {
            tile.getData().setCrop(theCrop, stage);
            tile.saveAndRefresh();
        }
    }

    @Override
    public List<ItemStack> harvestCrop(@Nullable EntityPlayer player, World world, BlockPos pos) {
        TileWithered tile;
        TileWithered tileWithered = tile = world.func_175625_s(pos) instanceof TileWithered ? (TileWithered)world.func_175625_s(pos) : null;
        if (tile != null) {
            CropData data = tile.getData();
            List<ItemStack> harvest = data.harvest(player, true);
            if (harvest != null) {
                if (data.getCrop().getRegrowStage() <= 0) {
                    if (!world.field_72995_K) {
                        world.func_175698_g(pos);
                    }
                } else {
                    tile.saveAndRefresh();
                }
                return harvest;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean hydrateSoil(@Nullable EntityPlayer player, World world, BlockPos pos) {
        boolean ret = false;
        IBlockState state = world.func_180495_p(pos);
        if (CropHelper.isSoil(state) && !CropHelper.isWetSoil(state)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)));
            ret = true;
        }
        return ret;
    }
}

