/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.crops.IStateHandler;
import joshie.harvest.core.helpers.SpawnItemHelper;
import joshie.harvest.crops.CropData;
import joshie.harvest.crops.block.BlockHFCrops;
import joshie.harvest.crops.tile.TileWithered;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class CropHelper {
    private static final Cache<BlockPos, IBlockState> RESERVE = CacheBuilder.newBuilder().expireAfterAccess(100L, TimeUnit.MILLISECONDS).maximumSize(64L).build();

    public static void onBottomBroken(BlockPos pos, IBlockState state) {
        RESERVE.put((Object)pos, (Object)state);
    }

    public static IBlockState getTempState(BlockPos pos) {
        return (IBlockState)RESERVE.getIfPresent((Object)pos);
    }

    public static TileWithered getTile(IBlockAccess world, BlockPos pos, IStateHandler.PlantSection section) {
        if (section == IStateHandler.PlantSection.BOTTOM) {
            return (TileWithered)world.func_175625_s(pos);
        }
        TileWithered down = (TileWithered)world.func_175625_s(pos.func_177977_b());
        return down == null ? (TileWithered)world.func_175625_s(pos) : down;
    }

    public static boolean isWetSoil(IBlockState state) {
        return state.func_177230_c() instanceof BlockFarmland && (Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a) == 7;
    }

    public static boolean isSoil(IBlockState state) {
        return state.func_177230_c() instanceof BlockFarmland;
    }

    public static boolean harvestCrop(EntityPlayer player, World world, BlockPos pos) {
        List<ItemStack> list = HFApi.crops.harvestCrop(player, world, pos);
        if (!world.field_72995_K && list != null && list.size() > 0) {
            for (ItemStack stack : list) {
                SpawnItemHelper.dropBlockAsItem(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
            }
        }
        return list != null;
    }

    @Nullable
    public static CropData getCropDataAt(IBlockAccess world, BlockPos pos) {
        TileEntity tile;
        IStateHandler.PlantSection section = BlockHFCrops.getSection(world.func_180495_p(pos));
        if (section == IStateHandler.PlantSection.BOTTOM) {
            TileEntity tile2 = world.func_175625_s(pos);
            if (tile2 instanceof TileWithered) {
                return ((TileWithered)tile2).getData();
            }
        } else if (section == IStateHandler.PlantSection.TOP && (tile = world.func_175625_s(pos.func_177977_b())) instanceof TileWithered) {
            return ((TileWithered)tile).getData();
        }
        return null;
    }

    public static boolean isRainingAt(World world, BlockPos pos) {
        if (!HFApi.calendar.getWeather(world).isRain()) {
            return false;
        }
        if (!world.func_175710_j(pos)) {
            return false;
        }
        if (world.func_175725_q(pos).func_177956_o() > pos.func_177956_o()) {
            return false;
        }
        Biome biome = world.func_180494_b(pos);
        return biome.func_76738_d() || biome.func_150559_j();
    }
}

