/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.api.crops.IStateHandler;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.crops.block.BlockHFCrops;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CropData {
    private static final Random rand = new Random();
    private Crop crop = Crop.NULL_CROP;
    private int stage = 1;
    private int daysWithoutWater;
    private boolean safe;
    private boolean isDead;

    public CropData setCrop(Crop crop, int stage) {
        this.crop = crop;
        this.stage = stage;
        return this;
    }

    public boolean newDay(World world, BlockPos pos) {
        if (this.isDead || this.crop == null || this.crop.requiresWater() && this.daysWithoutWater > 2 || !this.crop.getGrowthHandler().canGrow(world, pos, this.crop)) {
            this.isDead = true;
            return false;
        }
        if (HFCrops.GROWS_DAILY && (this.daysWithoutWater == 0 || !this.crop.requiresWater())) {
            this.grow(world, pos);
        }
        ++this.daysWithoutWater;
        return true;
    }

    public void grow(World world, BlockPos pos) {
        if (this.stage < this.crop.getStages()) {
            ++this.stage;
        }
        if (this.crop.isTurningToDouble(this.stage)) {
            world.func_180501_a(pos.func_177984_a(), HFCrops.CROPS.getStateFromEnum(BlockHFCrops.CropType.FRESH_DOUBLE), 2);
        }
        if (this.crop.growsToSide() != null && this.stage == this.crop.getStages() && !this.attemptToGrowToSide(world, pos)) {
            --this.stage;
        }
    }

    private boolean attemptToGrowToSide(World world, BlockPos pos) {
        return world.func_175656_a(pos, this.crop.growsToSide().func_176203_a(world.field_73012_v.nextInt(4)));
    }

    public ResourceLocation getResource() {
        return this.crop.getRegistryName();
    }

    public int getStage() {
        return this.stage;
    }

    @Nonnull
    public Crop getCrop() {
        return this.crop;
    }

    public boolean isClearable() {
        if (this.safe) {
            this.safe = false;
            return false;
        }
        return true;
    }

    public boolean markSafe(World world, BlockPos pos, IStateHandler.PlantSection section) {
        this.safe = true;
        if (section == IStateHandler.PlantSection.BOTTOM) {
            return world.func_175698_g(pos.func_177984_a());
        }
        return world.func_175698_g(pos);
    }

    public List<ItemStack> harvest(@Nullable EntityPlayer player, boolean doHarvest) {
        if (this.crop == null || this.crop.growsToSide() != null) {
            return null;
        }
        if (this.stage >= this.crop.getStages() || this.crop.requiresSickle() && this.stage >= this.crop.getMinimumCut()) {
            int originalStage = this.stage;
            if (doHarvest && this.crop.getRegrowStage() > 0) {
                this.stage = this.crop.getRegrowStage();
            }
            return this.crop.getDropHandler().getDrops(this.crop, originalStage, rand);
        }
        return null;
    }

    public void setHydrated() {
        this.daysWithoutWater = 0;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("CropResource")) {
            this.isDead = nbt.func_74767_n("IsDead");
            this.crop = (Crop)Crop.REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("CropResource")));
            this.stage = nbt.func_74771_c("CurrentStage");
            this.daysWithoutWater = nbt.func_74765_d("DaysWithoutWater");
        }
        if (this.crop == null) {
            this.crop = Crop.NULL_CROP;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.crop != null) {
            nbt.func_74757_a("IsDead", this.isDead);
            nbt.func_74778_a("CropResource", this.crop.getRegistryName().toString());
            nbt.func_74774_a("CurrentStage", (byte)this.stage);
            nbt.func_74777_a("DaysWithoutWater", (short)this.daysWithoutWater);
        }
        return nbt;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CropData other = (CropData)obj;
        return !(this.crop == null ? other.crop != null : !this.crop.equals(other.crop));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.crop == null ? 0 : this.crop.hashCode());
        return result;
    }
}

