/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.crops;

import java.util.HashMap;
import java.util.Random;
import joshie.harvest.api.animals.AnimalFoodType;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.crops.ICrop;
import joshie.harvest.api.crops.IDropHandler;
import joshie.harvest.api.crops.ISoilHandler;
import joshie.harvest.api.crops.IStateHandler;
import joshie.harvest.core.helpers.SeedHelper;
import joshie.harvest.core.util.Translate;
import joshie.harvest.crops.handlers.SoilHandlers;
import joshie.harvest.crops.handlers.StateHandlerDefault;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class Crop
implements ICrop {
    public static final HashMap<ResourceLocation, ICrop> CROPS = new HashMap();
    private static final Random rand = new Random();
    @SideOnly(value=Side.CLIENT)
    protected IStateHandler iconHandler;
    protected ResourceLocation resource = new ResourceLocation("harvestfestival", "null_crop");
    protected ISoilHandler soilHandler;
    protected IDropHandler dropHandler;
    protected Block growsToSide;
    protected boolean needsWatering;
    protected boolean alternativeName;
    protected boolean requiresSickle;
    protected ItemStack item;
    protected Season[] seasons;
    protected int cost;
    protected int sell;
    protected int stages;
    protected int regrow;
    protected int year;
    protected int bag_color;
    protected int doubleStage;
    protected AnimalFoodType foodType;

    public Crop() {
    }

    public Crop(ResourceLocation key, Season season, int cost, int sell, int stages, int regrow, int year, int color) {
        this(key, new Season[]{season}, cost, sell, stages, regrow, year, color);
    }

    public Crop(ResourceLocation key, Season[] seasons, int cost, int sell, int stages, int regrow, int year, int color) {
        this.resource = key;
        this.seasons = seasons;
        this.cost = cost;
        this.sell = sell;
        this.stages = stages;
        this.regrow = regrow;
        this.year = year;
        this.alternativeName = false;
        this.foodType = AnimalFoodType.VEGETABLE;
        this.bag_color = color;
        this.iconHandler = new StateHandlerDefault(this);
        this.soilHandler = SoilHandlers.farmland;
        this.needsWatering = true;
        this.doubleStage = Integer.MAX_VALUE;
        this.dropHandler = null;
        this.growsToSide = null;
        CROPS.put(key, this);
    }

    @Override
    public ICrop setHasAlternativeName() {
        this.alternativeName = true;
        return this;
    }

    @Override
    public ICrop setItem(ItemStack item) {
        this.item = item;
        return this;
    }

    @Override
    public ICrop setStateHandler(IStateHandler handler) {
        this.iconHandler = handler;
        return this;
    }

    @Override
    public ICrop setRequiresSickle() {
        this.requiresSickle = true;
        return this;
    }

    @Override
    public ICrop setAnimalFoodType(AnimalFoodType foodType) {
        this.foodType = foodType;
        return this;
    }

    @Override
    public ICrop setNoWaterRequirements() {
        this.needsWatering = false;
        return this;
    }

    @Override
    public ICrop setSoilRequirements(ISoilHandler handler) {
        this.soilHandler = handler;
        return this;
    }

    @Override
    public ICrop setBecomesDouble(int doubleStage) {
        this.doubleStage = doubleStage;
        return this;
    }

    @Override
    public ICrop setDropHandler(IDropHandler handler) {
        this.dropHandler = handler;
        return this;
    }

    @Override
    public ICrop setGrowsToSide(Block block) {
        this.growsToSide = block;
        return this;
    }

    @Override
    public boolean hasItemAssigned() {
        return this.item != null;
    }

    @Override
    public Season[] getSeasons() {
        return this.seasons;
    }

    @Override
    public long getSeedCost() {
        return this.cost;
    }

    @Override
    public long getSellValue(ItemStack stack) {
        return this.sell;
    }

    @Override
    public int getStages() {
        return this.stages;
    }

    @Override
    public int getPurchaseYear() {
        return this.year;
    }

    @Override
    public int getRegrowStage() {
        return this.regrow;
    }

    @Override
    public boolean requiresSickle() {
        return this.requiresSickle;
    }

    @Override
    public boolean requiresWater() {
        return this.needsWatering;
    }

    @Override
    public boolean isDouble(int stage) {
        return stage == this.doubleStage;
    }

    @Override
    public Block growsToSide() {
        return this.growsToSide;
    }

    @Override
    public ISoilHandler getSoilHandler() {
        return this.soilHandler;
    }

    @Override
    public boolean canPurchase() {
        return this.getSeedCost() > 0L;
    }

    @Override
    public int getColor() {
        return this.bag_color;
    }

    @Override
    public AnimalFoodType getFoodType() {
        return this.foodType;
    }

    @Override
    public ItemStack getSeedStack() {
        return SeedHelper.getSeedsFromCrop(this);
    }

    @Override
    public ItemStack getCropStack() {
        return this.item == null ? null : this.item.func_77946_l();
    }

    @Override
    public ItemStack getHarvested() {
        return this.dropHandler == null ? this.getCropStack() : this.dropHandler.getDrop(rand, this.item.func_77973_b());
    }

    @Override
    public IStateHandler getStateHandler() {
        return this.iconHandler;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return stack.func_77973_b() == this.getCropStack().func_77973_b();
    }

    @Override
    public ResourceLocation getResource() {
        return this.resource;
    }

    @Override
    public String getLocalizedName(boolean isItem) {
        String suffix = this.alternativeName ? (isItem ? ".item" : ".block") : "";
        return Translate.translate(this.resource.func_110624_b(), "crop." + StringUtils.replace((String)this.resource.func_110623_a(), (String)"_", (String)".") + suffix);
    }

    @Override
    public String getSeedsName() {
        String suffix = this.alternativeName ? ".block" : "";
        String name = Translate.translate(this.resource.func_110624_b(), "crop." + StringUtils.replace((String)this.resource.func_110623_a(), (String)"_", (String)".") + suffix);
        String seeds = Translate.translate("crop.seeds");
        String text = Translate.translate("crop.seeds.format.standard");
        text = StringUtils.replace((String)text, (String)"%C", (String)name);
        text = StringUtils.replace((String)text, (String)"%S", (String)seeds);
        return text;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ICrop && this.getResource().equals((Object)((ICrop)o).getResource());
    }

    public int hashCode() {
        return this.resource.hashCode();
    }
}

