/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util.interfaces;

import joshie.harvest.api.core.Size;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public interface ISizeable {
    default public ItemStack getStack(Item item, Size size) {
        return this.getStackOfSize(item, size, 1);
    }

    default public ItemStack getStackOfSize(Item item, Size size, int stackSize) {
        return new ItemStack(item, stackSize, this.getMeta() * 3 + size.ordinal());
    }

    public int getMeta();

    default public long getSellValue(Size size) {
        return size == Size.SMALL ? this.getSmall() : (size == Size.MEDIUM ? this.getMedium() : this.getLarge());
    }

    public long getSmall();

    public long getMedium();

    public long getLarge();
}

