/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util.holders;

import java.util.ArrayList;
import java.util.List;
import joshie.harvest.api.core.ISizedProvider;
import joshie.harvest.api.core.Size;
import joshie.harvest.core.base.item.ItemHFSizeable;
import joshie.harvest.core.util.holders.AbstractItemHolder;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SizeableHolder
extends AbstractItemHolder {
    private final ItemStack stack;
    private final ISizedProvider item;
    private final Object object;

    private SizeableHolder(ItemStack stack) {
        this.stack = stack;
        this.item = (ItemHFSizeable)stack.func_77973_b();
        this.object = this.item.getObject(stack);
    }

    public static SizeableHolder of(ItemStack stack) {
        return new SizeableHolder(stack);
    }

    @Override
    public List<ItemStack> getMatchingStacks() {
        if (this.matchingStacks != null && this.matchingStacks.size() > 0) {
            return this.matchingStacks;
        }
        this.matchingStacks = new ArrayList();
        this.matchingStacks.add(this.item.getStackOfSize(this.object, Size.SMALL, 1));
        this.matchingStacks.add(this.item.getStackOfSize(this.object, Size.MEDIUM, 1));
        this.matchingStacks.add(this.item.getStackOfSize(this.object, Size.LARGE, 1));
        return this.matchingStacks;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return stack.func_77973_b() == this.stack.func_77973_b() && this.item.getObject(stack) == this.item.getObject(this.stack);
    }

    public static SizeableHolder readFromNBT(NBTTagCompound tag) {
        return new SizeableHolder(ItemStack.func_77949_a((NBTTagCompound)tag));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return this.stack.func_77955_b(tag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SizeableHolder that = (SizeableHolder)o;
        if (this.item != null ? !this.item.equals(that.item) : that.item != null) {
            return false;
        }
        return this.object != null ? this.object.equals(that.object) : that.object == null;
    }

    public int hashCode() {
        int result = this.item != null ? this.item.hashCode() : 0;
        result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
        return result;
    }
}

