/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util.holders;

import java.util.List;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.core.util.holders.AbstractItemHolder;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class OreHolder
extends AbstractItemHolder {
    private final String ore;

    private OreHolder(String mod) {
        this.ore = mod;
    }

    public static OreHolder of(String mod) {
        return new OreHolder(mod);
    }

    @Override
    public List<ItemStack> getMatchingStacks() {
        return OreDictionary.getOres((String)this.ore);
    }

    @Override
    public boolean matches(ItemStack stack) {
        return InventoryHelper.ORE_DICTIONARY.matches(stack, this.ore);
    }

    public static OreHolder readFromNBT(NBTTagCompound tag) {
        return new OreHolder(tag.func_74779_i("Ore"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("Ore", this.ore);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OreHolder modHolder = (OreHolder)o;
        return this.ore != null ? this.ore.equals(modHolder.ore) : modHolder.ore == null;
    }

    public int hashCode() {
        return this.ore != null ? this.ore.hashCode() : 0;
    }
}

