/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util.holders;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.Mod;
import joshie.harvest.api.core.Ore;
import joshie.harvest.core.util.holders.AbstractItemHolder;
import joshie.harvest.core.util.holders.CropHolder;
import joshie.harvest.core.util.holders.FMLHolder;
import joshie.harvest.core.util.holders.ItemHolder;
import joshie.harvest.core.util.holders.ItemStackHolder;
import joshie.harvest.core.util.holders.ModHolder;
import joshie.harvest.core.util.holders.OreHolder;
import joshie.harvest.core.util.interfaces.IFMLItem;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class HolderRegistry<R> {
    private final LinkedHashMap<AbstractItemHolder, R> registry = new LinkedHashMap();

    public void register(Object object, R r) {
        if (object instanceof Item) {
            this.registry.put(ItemHolder.of((Item)object), r);
        } else if (object instanceof Block) {
            this.registry.put(ItemHolder.of(new ItemStack((Block)object).func_77973_b()), r);
        } else if (object instanceof ItemStack) {
            this.registry.put(this.getHolder((ItemStack)object), r);
        } else if (object instanceof Mod) {
            this.registry.put(ModHolder.of(((Mod)object).getMod()), r);
        } else if (object instanceof Ore) {
            this.registry.put(OreHolder.of(((Ore)object).getOre()), r);
        }
    }

    public boolean matches(ItemStack stack, R type) {
        R value = this.getValueOf(stack);
        return value != null && this.matches(value, type);
    }

    public R getValue(AbstractItemHolder holder) {
        return this.registry.get(holder);
    }

    public R getValueOf(ItemStack stack) {
        for (Map.Entry<AbstractItemHolder, R> entry : this.registry.entrySet()) {
            if (!entry.getKey().matches(stack)) continue;
            return entry.getValue();
        }
        return null;
    }

    public List<ItemStack> getStacksFor(R ingredient) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Map.Entry<AbstractItemHolder, R> entry : this.registry.entrySet()) {
            if (!this.matches(ingredient, entry.getValue())) continue;
            result.addAll(entry.getKey().getMatchingStacks());
        }
        return result;
    }

    public List<AbstractItemHolder> getStacks() {
        return new ArrayList<AbstractItemHolder>(this.registry.keySet());
    }

    public boolean matches(R external, R internal) {
        return external == internal;
    }

    private AbstractItemHolder getHolder(ItemStack stack) {
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            return ItemHolder.of(stack.func_77973_b());
        }
        if (HFApi.crops.getCropFromStack(stack) != null) {
            return CropHolder.of(HFApi.crops.getCropFromStack(stack));
        }
        if (stack.func_77973_b() instanceof IFMLItem) {
            return FMLHolder.of(stack);
        }
        return ItemStackHolder.of(stack);
    }
}

