/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util.holder;

import java.util.ArrayList;
import java.util.List;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.handlers.SizeableRegistry;
import joshie.harvest.core.lib.Sizeable;
import joshie.harvest.core.util.holder.AbstractItemHolder;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class SizeableHolder
extends AbstractItemHolder {
    private final Sizeable sizeable;

    private SizeableHolder(Sizeable sizeable) {
        this.sizeable = sizeable;
    }

    public static SizeableHolder of(Sizeable sizeable) {
        return new SizeableHolder(sizeable);
    }

    @Override
    public List<ItemStack> getMatchingStacks() {
        if (this.matchingStacks != null && this.matchingStacks.size() > 0) {
            return this.matchingStacks;
        }
        this.matchingStacks = new ArrayList();
        this.matchingStacks.add(this.sizeable.getStack(ISizeable.Size.SMALL));
        this.matchingStacks.add(this.sizeable.getStack(ISizeable.Size.MEDIUM));
        this.matchingStacks.add(this.sizeable.getStack(ISizeable.Size.LARGE));
        return this.matchingStacks;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return HFCore.SIZEABLE.getObjectFromStack(stack) == this.sizeable;
    }

    public static SizeableHolder readFromNBT(NBTTagCompound tag) {
        return new SizeableHolder((Sizeable)SizeableRegistry.REGISTRY.getValue(new ResourceLocation(tag.func_74779_i("Sizeable"))));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("Sizeable", SizeableRegistry.REGISTRY.getKey((IForgeRegistryEntry)this.sizeable).toString());
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SizeableHolder that = (SizeableHolder)o;
        return this.sizeable != null ? ((Object)((Object)this.sizeable)).equals((Object)that.sizeable) : that.sizeable == null;
    }

    public int hashCode() {
        return this.sizeable != null ? ((Object)((Object)this.sizeable)).hashCode() : 0;
    }
}

