/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util.holder;

import java.util.ArrayList;
import java.util.List;
import joshie.harvest.core.util.holder.AbstractItemHolder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ItemStackHolder
extends AbstractItemHolder {
    private final Item item;
    private final int meta;

    private ItemStackHolder(Item item, int meta) {
        this.item = item;
        this.meta = meta;
    }

    public static ItemStackHolder of(ItemStack stack) {
        return new ItemStackHolder(stack.func_77973_b(), stack.func_77952_i());
    }

    public static ItemStackHolder of(Item item, int meta) {
        return new ItemStackHolder(item, meta);
    }

    @Override
    public List<ItemStack> getMatchingStacks() {
        this.matchingStacks = new ArrayList();
        this.matchingStacks.add(new ItemStack(this.item, 1, this.meta));
        return this.matchingStacks;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return stack.func_77973_b() == this.item && stack.func_77952_i() == this.meta;
    }

    public static ItemStackHolder readFromNBT(NBTTagCompound tag) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("ItemName")));
        int meta = tag.func_74762_e("ItemMeta");
        return new ItemStackHolder(item, meta);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("ItemName", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.item)).toString());
        tag.func_74768_a("ItemMeta", this.meta);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackHolder that = (ItemStackHolder)o;
        if (this.meta != that.meta) {
            return false;
        }
        return this.item != null ? this.item.equals(that.item) : that.item == null;
    }

    public int hashCode() {
        int result = this.item != null ? this.item.hashCode() : 0;
        result = 31 * result + this.meta;
        return result;
    }
}

