/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util.holder;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import joshie.harvest.api.core.Mod;
import joshie.harvest.api.core.Ore;
import joshie.harvest.api.crops.ICropProvider;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.item.ItemSizeable;
import joshie.harvest.core.util.IFMLItem;
import joshie.harvest.core.util.holder.AbstractItemHolder;
import joshie.harvest.core.util.holder.CropHolder;
import joshie.harvest.core.util.holder.FMLHolder;
import joshie.harvest.core.util.holder.ItemHolder;
import joshie.harvest.core.util.holder.ItemStackHolder;
import joshie.harvest.core.util.holder.ModHolder;
import joshie.harvest.core.util.holder.OreHolder;
import joshie.harvest.core.util.holder.SizeableHolder;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class HolderRegistry<R> {
    private final HashMap<AbstractItemHolder, R> registry = new HashMap();
    private final Multimap<Item, AbstractItemHolder> keyMap = HashMultimap.create();

    public void removeItem(Item item) {
        this.keyMap.removeAll((Object)item);
    }

    private void registerHolder(Item item, AbstractItemHolder holder, R r) {
        this.keyMap.get((Object)item).add(holder);
        this.registry.put(holder, r);
    }

    public void register(Object object, R r) {
        block4: {
            block6: {
                block5: {
                    block3: {
                        if (object instanceof Item) {
                            this.registerHolder((Item)object, ItemHolder.of((Item)object), r);
                        }
                        if (!(object instanceof Block)) break block3;
                        ItemStack stack = new ItemStack((Block)object);
                        this.registerHolder(stack.func_77973_b(), ItemHolder.of(stack.func_77973_b()), r);
                        break block4;
                    }
                    if (!(object instanceof ItemStack)) break block5;
                    this.registerHolder(((ItemStack)object).func_77973_b(), this.getHolder((ItemStack)object), r);
                    break block4;
                }
                if (!(object instanceof Mod)) break block6;
                Mod mod = (Mod)object;
                ModHolder holder = ModHolder.of(mod.getMod());
                for (Item item : Item.field_150901_e) {
                    if (!item.getRegistryName().func_110624_b().equals(mod.getMod())) continue;
                    this.registerHolder(item, holder, r);
                }
                break block4;
            }
            if (!(object instanceof Ore)) break block4;
            Ore ore = (Ore)object;
            OreHolder holder = OreHolder.of(ore.getOre());
            for (ItemStack stack : OreDictionary.getOres((String)ore.getOre())) {
                this.registerHolder(stack.func_77973_b(), holder, r);
            }
        }
    }

    public boolean matches(ItemStack stack, R type) {
        Collection holders = this.keyMap.get((Object)stack.func_77973_b());
        for (AbstractItemHolder holder : holders) {
            if (!holder.matches(stack) || !this.matches(this.registry.get(holder), type)) continue;
            return true;
        }
        return false;
    }

    public R getValueOf(ItemStack stack) {
        Collection holders = this.keyMap.get((Object)stack.func_77973_b());
        for (AbstractItemHolder holder : holders) {
            if (!holder.matches(stack)) continue;
            return this.registry.get(holder);
        }
        return null;
    }

    public boolean matches(R external, R internal) {
        return external == internal;
    }

    private AbstractItemHolder getHolder(ItemStack stack) {
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            return ItemHolder.of(stack.func_77973_b());
        }
        if (stack.func_77973_b() instanceof ItemSizeable) {
            return SizeableHolder.of(HFCore.SIZEABLE.getObjectFromStack(stack));
        }
        if (stack.func_77973_b() instanceof ICropProvider) {
            return CropHolder.of(((ICropProvider)stack.func_77973_b()).getCrop(stack));
        }
        if (stack.func_77973_b() instanceof IFMLItem) {
            return FMLHolder.of(stack);
        }
        return ItemStackHolder.of(stack);
    }
}

