/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util.holder;

import java.util.ArrayList;
import java.util.List;
import joshie.harvest.core.util.IFMLItem;
import joshie.harvest.core.util.holder.AbstractItemHolder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class FMLHolder
extends AbstractItemHolder {
    private final IFMLItem item;
    private final ResourceLocation resource;

    private FMLHolder(ItemStack stack) {
        this.item = (IFMLItem)stack.func_77973_b();
        this.resource = this.item.getObjectFromStack(stack).getRegistryName();
    }

    private FMLHolder(IFMLItem item, ResourceLocation resource) {
        this.item = item;
        this.resource = resource;
    }

    public static FMLHolder of(ItemStack stack) {
        return new FMLHolder(stack);
    }

    @Override
    public List<ItemStack> getMatchingStacks() {
        this.matchingStacks = new ArrayList();
        this.matchingStacks.add(this.item.getStackFromResource(this.resource));
        return this.matchingStacks;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return stack.func_77973_b() == this.item && this.item.getObjectFromStack(stack).getRegistryName().equals((Object)this.resource);
    }

    public static FMLHolder readFromNBT(NBTTagCompound tag) {
        IFMLItem item = (IFMLItem)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("ItemName")));
        ResourceLocation resource = new ResourceLocation(tag.func_74779_i("Resource"));
        return new FMLHolder(item, resource);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("ItemName", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)((Item)this.item))).toString());
        tag.func_74778_a("Resource", this.resource.toString());
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FMLHolder fmlHolder = (FMLHolder)o;
        if (this.item != null ? !this.item.equals(fmlHolder.item) : fmlHolder.item != null) {
            return false;
        }
        return this.resource != null ? this.resource.equals((Object)fmlHolder.resource) : fmlHolder.resource == null;
    }

    public int hashCode() {
        int result = this.item != null ? this.item.hashCode() : 0;
        result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
        return result;
    }
}

