/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util.holder;

import java.util.ArrayList;
import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.core.util.holder.AbstractItemHolder;
import joshie.harvest.crops.CropRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class CropHolder
extends AbstractItemHolder {
    private final Crop crop;

    private CropHolder(Crop crop) {
        this.crop = crop;
    }

    public static CropHolder of(Crop crop) {
        return new CropHolder(crop);
    }

    @Override
    public List<ItemStack> getMatchingStacks() {
        this.matchingStacks = new ArrayList();
        this.matchingStacks.addAll(CropRegistry.INSTANCE.getStacksForCrop(this.crop));
        return this.matchingStacks;
    }

    @Override
    public boolean matches(ItemStack stack) {
        Crop container = HFApi.crops.getCropFromStack(stack);
        if (container != null) {
            return container == this.crop;
        }
        return false;
    }

    public static CropHolder readFromNBT(NBTTagCompound tag) {
        return new CropHolder((Crop)Crop.REGISTRY.getValue(new ResourceLocation(tag.func_74779_i("CropResource"))));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        if (this.crop != null) {
            tag.func_74778_a("CropResource", this.crop.getRegistryName().toString());
        }
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CropHolder that = (CropHolder)o;
        return this.crop != null ? this.crop.equals(that.crop) : that.crop == null;
    }

    public int hashCode() {
        return this.crop != null ? this.crop.hashCode() : 0;
    }
}

