/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Random;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.entity.EntityNPC;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.apache.commons.lang3.tuple.Triple;

public class Text {
    private static final Cache<Triple<String, String, ResourceLocation>, Integer> TRANSLATION_CACHE = CacheBuilder.newBuilder().build();
    private static final Random rand = new Random();

    public static String getSpeech(EntityNPC npc, String text) {
        return Text.getSpeech(npc.getNPC(), text);
    }

    public static String getSpeech(NPC npc, String text) {
        String key = npc.getLocalizationKey() + text;
        if (Text.canTranslate(key)) {
            return Text.localize(key);
        }
        String generic = npc.getGeneralLocalizationKey() + text;
        return Text.canTranslate(generic) ? Text.localize(generic) : Text.format("harvestfestival.npc.error", key, generic);
    }

    public static String getLang() {
        return "en_US";
    }

    public static String getRandomSpeech(INPC npc, String text, int maximumAlternatives, Object ... data) {
        int maximum = 1;
        try {
            Triple key = Triple.of((Object)Text.getLang(), (Object)text, (Object)npc.getResource());
            maximum = (Integer)TRANSLATION_CACHE.get((Object)key, () -> {
                int i;
                for (i = 1; i <= maximumAlternatives && Text.canTranslate(text + i); ++i) {
                }
                return i - 1;
            });
        }
        catch (Exception key) {
            // empty catch block
        }
        int random = 1 + (maximum >= 2 ? rand.nextInt(maximum) : 0);
        return data.length > 0 ? Text.format(text + random, data) : Text.localize(text + random);
    }

    public static String format(String key, Object ... data) {
        return I18n.func_74837_a((String)key, (Object[])data);
    }

    public static String formatHF(String key, Object ... data) {
        return I18n.func_74837_a((String)("harvestfestival." + key), (Object[])data);
    }

    public static String localize(String key) {
        return I18n.func_74838_a((String)key);
    }

    public static String localizeFully(String key) {
        return I18n.func_74838_a((String)key.replace("_", "."));
    }

    public static String translate(String s) {
        return I18n.func_74838_a((String)("harvestfestival." + s));
    }

    public static String translate(String mod, String s) {
        return I18n.func_74838_a((String)(mod + "." + s));
    }

    public static boolean canTranslate(String key) {
        return I18n.func_94522_b((String)key);
    }
}

