/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import joshie.harvest.buildings.placeable.Placeable;
import joshie.harvest.core.helpers.MCServerHelper;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HFTemplate {
    @Expose
    private Placeable[] components;

    public HFTemplate() {
    }

    public HFTemplate(ArrayList<Placeable> ret) {
        this.components = new Placeable[ret.size()];
        for (int j = 0; j < ret.size(); ++j) {
            this.components[j] = ret.get(j);
        }
    }

    public Placeable[] getComponents() {
        return this.components;
    }

    public EnumActionResult placeBlocks(World world, BlockPos pos, Rotation rotation) {
        if (this.components != null) {
            for (Placeable placeable : this.components) {
                placeable.place(world, pos, rotation, Placeable.ConstructionStage.BUILD, false);
            }
            for (Placeable placeable : this.components) {
                placeable.place(world, pos, rotation, Placeable.ConstructionStage.DECORATE, false);
            }
            for (Placeable placeable : this.components) {
                placeable.place(world, pos, rotation, Placeable.ConstructionStage.PAINT, false);
            }
            for (Placeable placeable : this.components) {
                placeable.place(world, pos, rotation, Placeable.ConstructionStage.MOVEIN, false);
            }
            MCServerHelper.markForUpdate(world, pos);
        }
        return EnumActionResult.SUCCESS;
    }
}

